<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RedirectIfNotAuditioneeParent
{
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::guard('auditionee_parent')->check()) {
            return redirect()->route('parent.login');
        }
        return $next($request);
    }
}
