<?php

namespace App\Jobs\Webhook\PayPal;


use App\Mail\AuditionPaid;
use App\Mail\CoursePaid;
use App\Mail\CppPaid;
use App\Mail\PaypalSuccess;
use App\Models\Auditionee;
use App\Models\Audition;
use App\Models\Attendee;
use App\Models\AuditioneeTransaction;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\SerializesModels;
use Spatie\WebhookClient\Models\WebhookCall;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class CheckoutOrderApprovedJob implements ShouldQueue
{
    use Queueable, SerializesModels;

    public function __construct(protected WebhookCall $webhookCall)
    {
        //
    }

    public function handle()
    {
        $message = $this->webhookCall->payload['resource'];
        
        //Log::info($message['purchase_units'][0]);
        
        
        $auditionee_id = $message['purchase_units'][0]['custom_id'];
        $amount = $message['purchase_units'][0]['amount']['value'];
        $reference_id  = $message['purchase_units'][0]['reference_id'];
        $paytype = explode("-", $reference_id);
        
        $auditioneeTransaction = AuditioneeTransaction::create([
            'status' => 'success',
            'amount' => $amount ,
            'type' => $paytype[1] ,
            'content' => serialize($message),
            'auditionee_id' => $auditionee_id,
        ]);
            
        // todo do something with $message['id']    
        
        $auditionee = Auditionee::find($auditionee_id);
        $to = $auditionee->email;
        $cc = false;
        if ($auditionee->secondary_email){
            $cc = $auditionee->secondary_email;
        }
        
        
        switch ($paytype[1]){
            case 'AUDITION':
                $audition_id = $paytype[2];
                
                $audition =  Audition::where(['auditionee_id' => $auditionee_id, 'venue_date_id' => $audition_id])->first();
                $audition->auditionee_transaction_id = $auditioneeTransaction->id;
                $audition->save();
                if ($cc){
                    Mail::to($to)->cc($cc)->send(new AuditionPaid($auditionee_id));
                } else {
                    Mail::to($to)->send(new AuditionPaid($auditionee_id));
                }
                
                Log::info('transaction id '.$auditioneeTransaction->id);
            break;
            case 'COURSE':
                $course_id = $paytype[2];
                $attendee =  Attendee::where(['auditionee_id' => $auditionee_id, 'course_id' => $course_id])->first();
                $attendee->auditionee_transaction_id = $auditioneeTransaction->id;
                $attendee->save();
                if ($cc){
                    Mail::to($to)->cc($cc)->send(new CoursePaid($auditionee_id,$course_id));
                } else {
                    Mail::to($to)->send(new CoursePaid($auditionee_id,$course_id));
                }
                Log::info('course paid '.$course_id);
            break;
            case 'CPP':
                if ($cc){
                    Mail::to($to)->cc($cc)->send(new CppPaid($auditionee_id));
                } else {
                    Mail::to($to)->send(new CppPaid($auditionee_id));
                }
            break;
            default :
                if ($cc){
                    Mail::to($to)->cc($cc)->send(new AuditionPaid($auditionee_id));
                } else {
                    Mail::to($to)->send(new AuditionPaid($auditionee_id));
                }
            break;
        
        }

        
        // make email
        
        
    }
}
