<?php

namespace App\Livewire\Auditionee;

use Livewire\Component;
use Livewire\Attributes\Validate;
use Illuminate\Validation\Rule;
use App\Livewire\Auditionee\Forms\NoteForm;
use App\Livewire\Auditionee\Forms\CommentForm;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\Auditionee;
use App\Models\AuditioneeComment;
use App\Models\Audition;
use App\Models\CommentCategory;
use App\Models\Project;
use App\Models\Recall;
use App\Models\Role;
use App\Models\Venue;
use App\Models\VenueDate;

class AuditionNote extends Component
{
    public NoteForm $form;
    public CommentForm $commentform;

    public $crud, $chosenvenue = false;
    public $venues,$projects,$venuedates,$commentcategories;
    
    public $showAddCommentDialog = false;

    public function mount(Request $request)
    {
                if ($request->id) {
                    $this->form->setUser($request->id);
                    $this->commentform->auditionee_id = $request->id;
                } 
        
    }

    
    
    public function addComment(){
        $this->commentform->save();
        $this->reset('showAddCommentDialog');
        sleep(1);
        session()->flash('message', 'Comment Successfully Added.');
    }
    
    public function deleteComment($id)
    {
        $audition = AuditioneeComment::find($id);
        $audition->delete();
        session()->flash('message', 'Comment Deleted Successfully.');
    }
    

    public function render()
    {
        
        
        if ($this->form->category){
            switch($this->form->category){
            case 'musician':
                $this->commentform->commentgroup =  'music';
            break;
            }
        }
        
        $query = CommentCategory::where('id','>',0);
        
        if ($this->commentform->commentgroup) {
            $query->where('type','=',$this->commentform->commentgroup);
        }
        
        $this->commentcategories = $query->orderBy("name")->get();
        
        
        
        $this->venues = Venue::all()->sortBy("name");
        $this->projects = Project::all()->sortBy("name");
        
        
        $query = VenueDate::where('id','>',0);
        
        // venue filter
    	if(strlen($this->chosenvenue)>=1){
    	    
    	    $venueResult = $this->chosenvenue;
    	    
    		$query->where('venue_id','=',$venueResult);
    	}
    	
    	$this->venuedates = $query->orderBy("start_date")->get();
    	
        
        $this->crud = "Create";
        if ($this->form->auditionee_id){
        $this->crud = "Update";
        }
        return view('nymt.auditionee.notesedit');
    }
    
    
    public function edit($id)

    {
        session()->flash('message', 'Auditionee Changed Successfully.');
        return redirect()->to('/auditionees/audition-notes/'.$id);

    }
    
    public function excerpt($text, $length)
    {
        return Str::limit($text, $length);
    }
}