<?php

namespace App\Livewire\Auditionee;

use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\WithFileUploads;
use Illuminate\Validation\Rule;
use App\Mail\AuditionPaid;
use App\Mail\CoursePaid;
use App\Mail\RoleOffer;
use App\Livewire\Auditionee\Forms\ProfileForm;
use App\Livewire\Auditionee\Forms\AuditionForm;
use App\Livewire\Auditionee\Forms\CommentForm;
use App\Livewire\Auditionee\Forms\RoleForm;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\Auditionee;
use App\Models\AuditioneeComment;
use App\Models\AuditioneeMedia;
use App\Models\Audition;
use App\Models\CommentCategory;
use App\Models\Project;
use App\Models\Recall;
use App\Models\Role;
use App\Models\Venue;
use App\Models\VenueDate;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\URL;
use App\Models\AuditioneeRole;

class Edit extends Component
{
    
    use WithFileUploads;
    
    public ProfileForm $form;
    public AuditionForm $auditionform;
    public CommentForm $commentform;
    public RoleForm $roleform;

    public $crud, $chosenvenue = false;
    public $venues,$projects,$venuedates,$commentcategories,$roles;
    public $showAddAudition = false;
    public $showAddMedia = false;
    public $showAddRole = false;
    public $showAddCommentDialog = false;
    public $media;
    public $project_id = false;

    public function mount(Request $request)
    {
                if ($request->id) {
                    $this->form->setUser($request->id);
                    $this->auditionform->auditionee_id = $request->id;
                    $this->commentform->auditionee_id = $request->id;
                    $this->roleform->auditionee_id = $request->id;
                } else{
                    $this->form->dob = date('Y-m-d');
                    $this->form->password = 'NYMT'; // lets make this more random
                }
        
    }

    public function save()
    {
        $this->form->update();

        sleep(1);

        session()->flash('message', 'Auditionee Successfully Updated.');
        redirect()->to('/auditionees/edit/'.$this->form->auditionee_id);
    }
    
    
    public function addComment(){
        $this->commentform->save();
        sleep(1);
        session()->flash('message', 'Comment Successfully Added.');
        
        $this->reset('showAddCommentDialog');
    }
    
    public function deleteComment($id)
    {
        $comment = AuditioneeComment::find($id);
        $comment->delete();
        session()->flash('message', 'Comment Deleted Successfully.');
    }
    
    
    
    public function addRole(){
        $this->roleform->save();
        
        sleep(1);
        session()->flash('message', 'Role Successfully Added.');
        
        $this->reset('showAddRole');
        redirect()->to('/auditionees/edit/'.$this->form->auditionee_id);
    }
    
    
    
    public function deleteRole($id)
    {
        $role = AuditioneeRole::find($id);
        $role->delete();
        session()->flash('message', 'Role Deleted Successfully.');
    }
    
    
    public function addMedia(){
        
        
        if ($this->media){
        $this->validate([
            'media' => 'mimes:jpeg,jpg,png,gif,pdf,doc,docx,mp4,mov|max:4094', // 4MB Max
        ]);

        $fileName = Str::slug(strip_tags($this->media->getClientOriginalName()), '-');
        
        $extension = $this->media->extension();
        
        $prefix ="";
        if ($this->form->auditionee_id && $this->form->auditionee_id > 0){
            $prefix = $this->auditionee_id;
        } else {
            $prefix = Carbon::now()->timestamp;;
        }
        $fileName = $prefix."_".str_replace($extension, '',$fileName).".".$extension;
    
        $this->media->storeAs('public/auditionee', $fileName);
        
        
        $newrank = $this->form->auditionee->media->max('rank') + 1;
        
        AuditioneeMedia::create([
            'url' => $fileName,
            'status' => 1,
            'auditionee_id' => $this->form->auditionee->id,
            'rank' => $newrank
            ]);
        
        }
        
        sleep(1);
        session()->flash('message', 'Media Successfully Added.');
        
        $this->reset('showAddMedia');
        redirect()->to('/auditionees/edit/'.$this->form->auditionee_id);
    }
    
    public function deleteMedia($id)
    {
        $audition = AuditioneeMedia::find($id);
        $audition->delete();
        session()->flash('message', 'Media Deleted Successfully.');
    }
    
    
    public function addAudition(){
        $this->auditionform->save();
        sleep(1);
        session()->flash('message', 'Auditionee Successfully Added.');
        
        $this->reset('showAddAudition');
    }
    
    public function deleteAudition($id)
    {
        $audition = Audition::find($id);
        $audition->delete();
        session()->flash('message', 'Audition Deleted Successfully.');
    }
    
    
    public function deleteRecall($id)
    {
        $audition = Recall::find($id);
        $audition->delete();
        session()->flash('message', 'Recall Deleted Successfully.');
    }

    public function render()
    {
        
        $this->venues = Venue::all()->sortBy("name");
        $this->projects = Project::all()->sortBy("name");
        
        $query = CommentCategory::where('id','>',0);
        
        if ($this->commentform->commentgroup) {
            $query->where('type','=',$this->commentform->commentgroup);
        }
        
        $this->commentcategories = $query->orderBy("name")->get();
        
        $query = VenueDate::where('id','>',0);
        
        // venue filter
    	if(strlen($this->chosenvenue)>=1){
    	    
    	    $venueResult = $this->chosenvenue;
    	    
    		$query->where('venue_id','=',$venueResult);
    	}
    	
    	$this->venuedates = $query->orderBy("start_date")->get();
        $this->roles = false;
    	if($this->project_id > 0 ){
            $this->roles = Role::where('project_id', $this->project_id)->get();
    	}
    	
        
        $this->crud = "Create";
        if ($this->form->auditionee_id){
        $this->crud = "Update";
        }
        return view('nymt.auditionee.edit');
    }
    
    public function excerpt($text, $length)
    {
        return Str::limit($text, $length);
    }
    
    public function sendAudition($auditionee_id)
    {
        $auditionee = Auditionee::find($auditionee_id);
        if ($auditionee->secondary_email){
            Mail::to($auditionee->email)->cc($auditionee->secondary_email)->send(new AuditionPaid($auditionee_id));
        } else {
            Mail::to($auditionee->email)->send(new AuditionPaid($auditionee_id));
        }
        
        Mail::to($auditionee->email)->send(new AuditionPaid($auditionee_id));
        session()->flash('message', 'Audition Email Successfully sent to '.$auditionee->email.' .');
    }
    
    public function sendCourse($auditionee_id,$course_id)
    {
        $auditionee = Auditionee::find($auditionee_id);
        if ($auditionee->secondary_email){
            Mail::to($auditionee->email)->cc($auditionee->secondary_email)->send(new CoursePaid($auditionee_id,$course_id));
        } else {
            Mail::to($auditionee->email)->send(new CoursePaid($auditionee_id,$course_id));
        }
        session()->flash('message', 'Course Email Successfully sent to '.$auditionee->email.' .');
    }
    
    public function sendOffer($auditionee_id,$project_id)
    {
        $auditionee = Auditionee::find($auditionee_id);
        if ($auditionee->secondary_email){
            Mail::to($auditionee->email)->cc($auditionee->secondary_email)->send(new RoleOffer($auditionee_id,$project_id));
        } else {
            Mail::to($auditionee->email)->send(new RoleOffer($auditionee_id,$project_id));
        }       
        session()->flash('message', 'Role Offers Successfully sent to '.$auditionee->email.' .');
    }
    
    public function generateLink($auditionee_id)
    {
        $detailsUrl = 
         URL::temporarySignedRoute(
            'ycm.course', now()->addDays(21), [
                    'id' => $auditionee_id,
                ]
        );
        session()->flash('message', 'Audition Link is: '.$detailsUrl.' .');
    }
    
}