<?php

namespace App\Livewire\Auditionee\Forms;

use Livewire\Form;
use Livewire\Attributes\Validate;
use Illuminate\Validation\Rule;
use App\Models\Auditionee;
use App\Models\AuditioneePastoral;
use App\Enums\Country;

class NoteForm extends Form
{
    public Auditionee $auditionee;
    public AuditioneePastoral $pastoral;
    #[Validate]
    public $firstname= ''; 
    public $lastname = '';
    public $email = '';
    public $dob = '';
    public $address = '';
    public $tel = '';
    public $emergency_tel = '';
    public $emergency_tel_alt = '';
    public $ethnicity = '';
    public $category = '';
    public $dancing_experience = '';
    public $singing_experience = '';
    public $acting_experience = '';
    public $profile_photo_path = '';
    public $profile_video_path = '';
    public $auditionee_id = false;
    public $password = '';
    public $licensed = 0;
    public $license_info = '';
    public $pastoral_id = false;
    public $pastoral_dietry = '';
    public $pastoral_allergies = '';
    public $pastoral_epipen = 0;
    public $pastoral_inhaler = 0;
    public $pastoral_offsite = 0;
    public $pastoral_medical_info = '';
    public $pastoral_comment = '';
    
    public Country $country;
    
    
    public function rules()
    {
        return [
            'firstname' => [
                'required'
            ]
        ];
    }

    public function setUser($id)
    {
        
        $auditionee = Auditionee::find($id);
        
        if ($auditionee){
        $this->auditionee = $auditionee;

        $this->auditionee_id = $auditionee->id;
        $this->firstname = $this->auditionee->firstname;
        $this->lastname = $this->auditionee->lastname;
        $this->email = $this->auditionee->email;
        $this->dob = date('Y-m-d', strtotime($this->auditionee->dob));
        $this->address = $this->auditionee->address;
        $this->country = $this->auditionee->country;
        $this->tel = $this->auditionee->tel;
        $this->emergency_tel = $this->auditionee->emergency_tel;
        $this->emergency_tel_alt = $this->auditionee->emergency_tel_alt;
        $this->ethnicity = $this->auditionee->ethnicity;
        $this->category = $this->auditionee->category;
        $this->dancing_experience = $this->auditionee->dancing_experience;
        $this->singing_experience = $this->auditionee->singing_experience;
        $this->acting_experience = $this->auditionee->acting_experience;
        $this->profile_photo_path = $this->auditionee->profile_photo_path;
        $this->profile_video_path = $this->auditionee->profile_video_path;
        $this->licensed = $this->auditionee->licensed;
        $this->license_info = $this->auditionee->license_info;
        $this->password = $this->auditionee->password;
        
        if ($auditionee->pastoral){
            $this->pastoral = AuditioneePastoral::find($auditionee->pastoral->id);
            $this->pastoral_id = $this->pastoral->id;
            $this->pastoral_dietry = $this->pastoral->dietry;
            $this->pastoral_allergies = $this->pastoral->allergies;
            $this->pastoral_epipen = $this->pastoral->epipen;
            $this->pastoral_inhaler = $this->pastoral->inhaler;
            $this->pastoral_offsite = $this->pastoral->offsite;
            $this->pastoral_medical_info = $this->pastoral->medical_info;
            $this->pastoral_comment = $this->pastoral->comment;
        }
        
        
        } 

    }

    public function update()
    {
        $this->validate();

        $this->auditionee = Auditionee::updateOrCreate(['id' => $this->auditionee_id], [
            'firstname' => $this->firstname,
            'lastname' => $this->lastname,
            'email' => $this->email,
            'dob' => date('Y-m-d H:i:s' , strtotime($this->dob)),
            'address' => $this->address,
            'country' => $this->country,
            'tel' => $this->tel,
            'emergency_tel' => $this->emergency_tel,
            'emergency_tel_alt' => $this->emergency_tel_alt,
            'ethnicity' => $this->ethnicity,
            'category' => $this->category,
            'dancing_experience' => $this->dancing_experience,
            'singing_experience' => $this->singing_experience,
            'acting_experience' => $this->acting_experience,
            'profile_photo_path' => $this->profile_photo_path,
            'profile_video_path' => $this->profile_video_path,
            'licensed' => $this->licensed,
            'license_info' => $this->license_info,
            'password' => $this->password,
        ]);
        $this->auditionee_id = $this->auditionee->id;
        $this->pastoral = AuditioneePastoral::updateOrCreate(['id' => $this->pastoral_id], [
            'dietry' => $this->pastoral_dietry,
            'allergies' => $this->pastoral_allergies,
            'epipen' => $this->pastoral_epipen,
            'inhaler' => $this->pastoral_inhaler,
            'offsite' => $this->pastoral_offsite,
            'medical_info' => $this->pastoral_medical_info,
            'comment' => $this->pastoral_comment,
            'auditionee_id' => $this->auditionee_id,
        ]);
        $this->pastoral_id = $this->pastoral->id;
    }
}