<?php

namespace App\Livewire\Component;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\VenueDate;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;

class AuditionDash extends Component
{
    use WithPagination;
    

    public function render()
    {
        
        
        $today = date('y-m-d');
        
        $query = VenueDate::where('id','>',0);
        
    	
    	$query->where('start_date','>=',$today);
    	$query->orderBy('start_date','asc');

        return view('nymt.dashboard.auditions', [
            'myvenuedates' => $query->limit(5)->get(),
            ]);

    }
    
    
    
    public function auditionlist($id){
        
        return redirect()->to('/auditionees/audition-list/'.$id.'?view=list');
    }


}