<?php

namespace App\Livewire\Component;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Project;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;

class ProjectDash extends Component
{
    use WithPagination;
    

    public function render()
    {
        
        
        $today = date('y-m-d');
        
        $query = Project::where('id','>',0);
        
    	
    	$query->where('end_date','>=',$today);
    	$query->where('cast_date','<=',$today);
    	$query->orderBy('start_date','asc');

        return view('nymt.dashboard.projects', [
            'myprojects' => $query->limit(10)->get(),
            ]);

    }
    
    
    
    public function project($id){
        
        return redirect()->to('/roles/list/'.$id.'?view=list');
    }
    
    public function excerpt($text, $length)
    {
        return Str::limit($text, $length);
    }


}