<?php

namespace App\Livewire\Course;

use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\WithFileUploads;
use Illuminate\Validation\Rule;
use App\Livewire\Course\Forms\MainForm;
use Illuminate\Http\Request;
use App\Models\Attendee;

class Edit extends Component
{
    use WithFileUploads;
    public MainForm $form;
    public $showSuccessIndicator = false, $crud;

    public function mount(Request $request)
    {
                if ($request->id) {
                    $this->form->setCourse($request->id);
                } else {
                    $this->form->course_id = false;
                    $this->form->start_date = date('Y-m-d');
                    $this->form->end_date = date('Y-m-d', strtotime('tomorrow'));
                }
    }

    public function save()
    {
        
        if ($this->form->course_id){
            $message = "Updated";
        } else {
            $message = "Created";
        }
        $this->form->update();
        $this->crud = "Update";
        
        sleep(1);
        
        session()->flash('message', 'Course '.$message.' Successfully.');

        //return redirect()->to('/courses/');
    }
    
    
    public function editAttendee($id){
        return redirect()->to('/auditionees/edit/'.$id);
    }
    
    public function deleteAttendee($id)
    {
        $attendee = Attendee::find($id);
        $attendee->delete();
        session()->flash('message', 'Attendee Deleted Successfully.');
    }
    

    public function render()
    {
        
        $this->crud = "Create";
        if ($this->form->course_id){
        $this->crud = "Update";
        }
        return view('nymt.course.edit');
    }
    
    
}