<?php

namespace App\Livewire\Frontend;


use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\WithFileUploads;
use Illuminate\Validation\Rule;
use App\Livewire\Frontend\Forms\UserForm;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\Auditionee;
use App\Models\Audition;
use App\Models\Project;
use App\Models\Venue;
use App\Models\VenueDate;

class AuditioneeProfile extends Component
{
    
    use WithFileUploads;
    public UserForm $form;

    public $venues,$projects,$venuedates,$commentcategories;
    
    public function mount(Request $request)
    {
                if ($request->id) {
                    $this->form->setUser($request->id);
                } else{
                    exit;
                }
    }

    public function render()
    {
        return view('frontend.profile')
            ->layout('layouts.frontend');
    }

    public function openModal()
    {
        $this->showModal = true;
    }
    public function save()
    {
        $this->form->update();

        sleep(1);

        session()->flash('message', 'Auditionee Successfully Updated.');
    }
    
    
    
}