<?php

namespace App\Livewire\Frontend\Forms;

use Livewire\Form;
use Livewire\WithFileUploads;
use Livewire\Attributes\Validate;
use Illuminate\Support\Str;
use App\Models\Auditionee;
use App\Models\AuditioneeCasting;
use App\Models\AuditioneePastoral;
use App\Enums\Country;

class AttendeeForm extends Form
{
    use WithFileUploads;
    
    public Auditionee $auditionee;
    public AuditioneePastoral $pastoral;
    
    
    public $auditionee_id = 0;
    #[Validate('required')]
    public $birth_gender = false;
    #[Validate('required')]
    public $emergency_2_contact = '';
    #[Validate('required')]
    public $emergency_2_relationship = '';
    #[Validate('required')]
    public $emergency_2_tel = '';

    //casting
    public $casting_id = false;
    public $residential = 0;
    #[Validate('required')]
    public $language_disclaimer = false;
    public $children = [];
    public $medical_info = [];
    public $medical_info_other = '';
    public $medical_more_info = '';
    public $homesickness = 0;
    public $dietry = [];
    #[Validate('required')]
    public $consent = false;
    public $consent_exceptions = '';
    public $casting_offsite = false;
    #[Validate('required')]
    public $casting_fee = false;
    #[Validate('required')]
    public $casting_accept = '';
    

    
    
    public function setUser($id)
    {
        
        $auditionee = Auditionee::find($id);
        
        if ($auditionee){
        $this->auditionee = $auditionee;

        $this->auditionee_id = $auditionee->id;
        
        $this->emergency_2_contact = $this->auditionee->emergency_2_contact;
        $this->emergency_2_relationship = $this->auditionee->emergency_2_relationship;
        $this->emergency_2_tel = $this->auditionee->emergency_2_tel;
        $this->birth_gender = $this->auditionee->birth_gender;
        
 
        if ($auditionee->casting){
            $this->casting = AuditioneeCasting::find($auditionee->casting->id);
            $this->casting_id = $this->casting->id;
            $this->casting_offsite = $this->casting->offsite;
            $this->residential = $this->casting->residential;
            $this->language_disclaimer = $this->casting->language_disclaimer;
            $this->medical_info = $this->casting->medical_info ? json_decode($this->casting->medical_info) : [];
            $this->medical_info_other = $this->casting->medical_info_other;
            $this->medical_more_info = $this->casting->medical_more_info;
            $this->children =  $this->casting->children ? json_decode($this->casting->children) : [];
            $this->homesickness = $this->casting->homesickness;
            $this->dietry = $this->casting->dietry ? json_decode($this->casting->dietry) : [];
            $this->consent = $this->casting->consent;
            $this->consent_exceptions = $this->casting->consent_exceptions;
            $this->casting_fee = $this->casting->fee;
            $this->casting_accept = $this->casting->accept;
        }
        
        
        } 

    }

    public function update()
    {
        $this->validate();
        
        $this->auditionee = Auditionee::updateOrCreate(['id' => $this->auditionee_id], [
            'emergency_2_contact' => $this->emergency_2_contact,
            'emergency_2_relationship' => $this->emergency_2_relationship,
            'emergency_2_tel' => $this->emergency_2_tel,
            'birth_gender' => $this->birth_gender,
        ]);
        $this->auditionee_id = $this->auditionee->id;
        $this->casting = AuditioneeCasting::updateOrCreate(['id' => $this->casting_id], [
            'offsite' => $this->casting_offsite,
            'residential' => $this->residential,
            'language_disclaimer' => $this->language_disclaimer,
            'medical_info' => json_encode($this->medical_info),
            'medical_info_other' => $this->medical_info_other,
            'medical_more_info' => $this->medical_more_info,
            'children' => json_encode($this->children),
            'homesickness' => $this->homesickness,
            'dietry' => json_encode($this->dietry),
            'consent' => $this->consent,
            'consent_exceptions' => $this->consent_exceptions,
            'fee' => $this->casting_fee,
            'accept' => $this->casting_accept,
            'auditionee_id' => $this->auditionee_id,
        ]);
        $this->casting_id = $this->casting->id;
        
    }
}