<?php

namespace App\Livewire\Frontend\Forms;

use Livewire\Form;
use Livewire\WithFileUploads;
use Livewire\Attributes\Validate;
use Illuminate\Support\Str;
use App\Models\Auditionee;
use App\Models\AuditioneeCasting;
use App\Models\AuditioneePastoral;
use App\Enums\Country;
use Carbon\Carbon;

class CourseForm extends Form
{
    use WithFileUploads;
    
    public Auditionee $auditionee;
    public AuditioneePastoral $pastoral;
    
    
    #[Validate('required', message: 'Please enter the name you would like to be known by')]
    public $firstname= ''; 
    #[Validate('required', message: 'Please enter your last name')]
    public $lastname = '';
    public $formalname = '';
    #[Validate('required|email|unique:auditionees', message: 'Please enter your email')]
    public $email = '';
    #[Validate('email', message: 'Please enter your email')]
    public $secondary_email = '';
    #[Validate('required', message: 'Please enter your date of birth!')]
    public $dob = '';
    #[Validate('required')]
    public $address = '';
    #[Validate('required')]
    public $town = '';
    #[Validate('required')]
    public $postcode = '';
    public $tel = '';
    #[Validate('required')]
    public $emergency_contact = '';
    #[Validate('required')]
    public $emergency_relationship = '';
    #[Validate('required')]
    public $emergency_tel = '';
    public $ethnicity = '';
    #[Validate('required', message: 'Please choose one - prefer not to say is absolutely fine!')]
    public $gender = '';
    public $category = 'actor';
    public $password = '';
    
    public $profile_photo_path = '';
    public $profile_video_path = '';
    
    #[Validate('image|max:4096')] // 4MB Max
    public $photo;
    
    #[Validate('required')]
    public Country $country;
    
    
    public $auditionee_id = 0;
    #[Validate('required')]
    public $birth_gender = '';
    #[Validate('required')]
    public $emergency_2_contact = '';
    #[Validate('required')]
    public $emergency_2_relationship = '';
    #[Validate('required')]
    public $emergency_2_tel = '';

    //casting
    public $casting_id = false;
    public $residential= 0;
    public $language_disclaimer= 0;
    public $children= [];
    public $medical_info= [];
    public $medical_info_other= '';
    public $medical_more_info= '';
    public $homesickness= 0;
    public $dietry= [];
    #[Validate('required')]
    public $consent= '';
    public $consent_exceptions= '';
    public $casting_offsite = 1;
    public $casting_fee= 0;
    public $casting_accept= '';
    
    
    //pastoral
    public $pastoral_id = false;
    public $pastoral_allergies = '';
    public $pastoral_epipen = 0;
    public $pastoral_inhaler = 0;
    public $pastoral_comment = ''; 
    public $pastoral_barriers = '';
    public $pastoral_disability = '';

    
    
    public function update()
    {
        $this->validate();
        
        if ($this->photo){
        $fileName = Str::slug(strip_tags($this->photo->getClientOriginalName()), '-');
        
        $extension = $this->photo->extension();
        
        $prefix ="";
        if ($this->auditionee_id && $this->auditionee_id > 0){
            $prefix = $this->auditionee_id;
        } else {
            $prefix = Carbon::now()->timestamp;;
        }
        
        $fileName = $prefix."_".str_replace($extension, '',$fileName).".".$extension;
        $this->profile_photo_path = $fileName;
        $this->photo->storeAs('public/auditionee', $fileName);
        }
        
        $this->auditionee = Auditionee::updateOrCreate(['id' => $this->auditionee_id], [
            'firstname' => $this->firstname,
            'lastname' => $this->lastname,
            'formalname' => $this->formalname,
            'email' => $this->email,
            'secondary_email' => $this->secondary_email,
            'dob' => date('Y-m-d H:i:s' , strtotime($this->dob)),
            'address' => $this->address,
            'town' => $this->town,
            'postcode' => $this->postcode,
            'country' => $this->country,
            'tel' => $this->tel,
            'emergency_contact' => $this->emergency_contact,
            'emergency_relationship' => $this->emergency_relationship,
            'emergency_tel' => $this->emergency_tel,
            'ethnicity' => $this->ethnicity,
            'gender' => $this->gender,
            'category' => $this->category,
            'profile_photo_path' => $this->profile_photo_path,
            'profile_video_path' => $this->profile_video_path,
            'emergency_2_contact' => $this->emergency_2_contact,
            'emergency_2_relationship' => $this->emergency_2_relationship,
            'emergency_2_tel' => $this->emergency_2_tel,
            'birth_gender' => $this->birth_gender,
            'password' => $this->password,
        ]);
        $this->auditionee_id = $this->auditionee->id;
        $this->pastoral = AuditioneePastoral::updateOrCreate(['id' => $this->pastoral_id], [
            'allergies' => $this->pastoral_allergies,
            'epipen' => $this->pastoral_epipen,
            'inhaler' => $this->pastoral_inhaler,
            'barriers' => $this->pastoral_barriers,
            'disability' => $this->pastoral_disability,
            'comment' => $this->pastoral_comment,
            'auditionee_id' => $this->auditionee_id,
        ]);
        $this->pastoral_id = $this->pastoral->id;
        $this->casting = AuditioneeCasting::updateOrCreate(['id' => $this->casting_id], [
            'offsite' => $this->casting_offsite,
            'residential' => $this->residential,
            'language_disclaimer' => $this->language_disclaimer,
            'medical_info' => json_encode($this->medical_info),
            'medical_info_other' => $this->medical_info_other,
            'medical_more_info' => $this->medical_more_info,
            'children' => json_encode($this->children),
            'homesickness' => $this->homesickness,
            'dietry' => json_encode($this->dietry),
            'consent' => $this->consent,
            'consent_exceptions' => $this->consent_exceptions,
            'fee' => $this->casting_fee,
            'accept' => $this->casting_accept,
            'auditionee_id' => $this->auditionee_id,
        ]);
        $this->casting_id = $this->casting->id;
        
    }
    
    public function ageAtDate($futureDate)
    {
        $dob = Carbon::parse($this->dob);
        $future = Carbon::parse($futureDate);
        return floor($dob->diffInYears($future));
    }
}