<?php

namespace App\Livewire\Frontend;

use App\Models\Auditionee;
use App\Models\Course;
use Livewire\Component;
use Srmklive\PayPal\Services\PayPal as PayPalClient;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;

class PayCourseController extends Component

{
    
    public $course_id,$course;
    public Auditionee $ycm;
    
    public function mount(Request $request)
    {
                if ($request->id) {
                    $request->session()->put('auditioneeId', $request->id);
                }
                if ($request->course) {
                    $this->course_id = $request->course;
                    $request->session()->put('courseId', $request->course);
                }
                
                $auditioneeId = $request->session()->get('auditioneeId');
                $courseId = $request->session()->get('courseId');
                
                
                $this->course = Course::find($courseId);

                $this->ycm = Auditionee::find($auditioneeId);
    }
    
    
    public function render()
    {
        
        
        
        return view('frontend.pay-course')
            ->layout('layouts.frontend-ycm');
    }
    

    /**

     * Write code on Method
     *
     * @return response()
     */

    public function index(Request $request)

    {
        if ($request->id) {
            $request->session()->put('auditioneeId', $request->id);
        }
        if ($request->course) {
            $this->course_id = $request->course;
        }
        
        
        return view('frontend.pay-course')
            ->layout('layouts.frontend-ycm');
    }
    
    
    public function viewdetails(Request $request){
            $detailsUrl = URL::signedRoute('ycm.casting', [
            'id' => $request->session()->get('auditioneeId'),
            ]);
            
            return redirect($detailsUrl);
    
    }

  

    /**
     * Write code on Method
     *
     * @return response()
     */

    public function payment(Request $request)

    {
        
        
        $auditioneeId = $request->session()->get('auditioneeId');

        $auditionee = Auditionee::find($auditioneeId);
        
        if (!$auditionee){
            
            return redirect()
                ->route('cancel.payment')
                ->with('error', 'No Auditionee Please start again.');
            
        }
        
        $reference_id = "NYMT-COURSE-".$this->course->id."-".$auditionee->id;
        
        $fee = $this->course->price ?? 0;
        
        if ($fee == 0){
            
            return "No fee for this course";
            
        }
        // for testing
        //$fee = 0.01;
        
        $provider = new PayPalClient;
        $provider->setApiCredentials(config('paypal'));
        $paypalToken = $provider->getAccessToken();

        $response = $provider->createOrder([

            "intent" => "CAPTURE",

            "application_context" => [
                "return_url" => route('paypalCourse.payment.success'),
                "cancel_url" => route('paypalCourse.payment.cancel'),
            ],

            "purchase_units" => [

                0 => [
                    "custom_id" => $auditionee->id,
                    "reference_id" => $reference_id,
                    "amount" => [
                        "currency_code" => "GBP",
                        "value" => $fee

                    ]
                ]
            ]
        ]);

  

        if (isset($response['id']) && $response['id'] != null) {

            foreach ($response['links'] as $links) {

                if ($links['rel'] == 'approve') {
                    return redirect()->away($links['href']);
                }
            }

            return redirect()
                ->route('paypalCourse', [
                    'id' => $request->session()->get('auditioneeId'),
                    'course' => $request->session()->get('courseId')
                    ])
                ->with('error', 'Something went wrong.');

        } else {

            return redirect()
                ->route('paypalCourse', [
                    'id' => $request->session()->get('auditioneeId'),
                    'course' => $request->session()->get('courseId')
                    ])
                ->with('error', $response['message'] ?? 'Something went wrong.'.$auditionee->category);

        }
    }

  

    /**
     * Write code on Method
     *
     * @return response()
     */

    public function paymentCancel(Request $request)

    {

        return redirect()
              ->route('paypalCourse', [
                    'id' => $request->session()->get('auditioneeId'),
                    'course' => $request->session()->get('courseId')
                  ])
              ->with('error', $response['message'] ?? 'You have canceled the transaction.');
    }

    /**
     * Write code on Method
     *
     * @return response()
     */

    public function paymentSuccess(Request $request)

    {

        $provider = new PayPalClient;
        $provider->setApiCredentials(config('paypal'));
        $provider->getAccessToken();
        $response = $provider->capturePaymentOrder($request['token']);


        if (isset($response['status']) && $response['status'] == 'COMPLETED') {

            return redirect()
                ->route('paypalCourse', [
                    'id' => $request->session()->get('auditioneeId'),
                    'course' => $request->session()->get('courseId')
                    ])
                ->with('success', 'Transaction complete.');

        } else {

            return redirect()
                ->route('paypalCourse', [
                    'id' => $request->session()->get('auditioneeId'),
                    'course' => $request->session()->get('courseId')
                    ])
                ->with('error', $response['message'] ?? 'Something went wrong.');

        }

    }

}