<?php

namespace App\Livewire\Frontend;

use App\Models\Auditionee;
use App\Models\AuditioneeComment;
use App\Models\AuditioneeParent;
use App\Models\Audition;
use App\Models\CommentCategory;
use App\Models\Project;
use App\Models\Venue;
use App\Models\VenueDate;
use App\Livewire\Frontend\Forms\UserForm;
use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\WithFileUploads;
use Illuminate\Validation\Rule;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;

use Illuminate\Support\Facades\Auth;

class Start extends Component
{
    
    use WithFileUploads;
    public UserForm $form;
    public $formType,$venuedate,$venuedateid = 0;

    public $crud, $password, $chosenvenue = false;
    public $venues,$projects,$venuedates,$commentcategories;
    public $showAddPostDialog = false;
    public $showAddCommentDialog = false;

    public $emailExists= false;


    public function mount(Request $request)
    {
                if ($request->formType) {
                    $this->formType = $request->formType;
                }
                if ($request->applicationType) {
                    $this->form->category = $request->applicationType;
                }
                if ($request->venue) {
                    if ($request->venue >0){
                    $this->venuedate = VenueDate::find($request->venue);
                    $this->venuedateid = $request->venue;
                    } else {
                    $this->venuedate = false; 
                    $this->venuedateid = 0;
                    }
                }
                $hashed_random_password = Hash::make(Str::random(6));
                    $this->form->password = 'NYMT'.$hashed_random_password; 
        
    }
    
    

    public function render()
    {
        $this->crud = 'empty';
        
        switch ($this->form->category){
            case 'actor':
            $this->crud = "Audition: ".date('l jS F', strtotime($this->venuedate->start_date))." | ".$this->venuedate->venue->town;
            break;
            case 'stage_manager':
            $this->crud = 'Actor';
            break;
            case 'musician':
            $this->crud = 'Musician';
            break;
            case 'cpp':
            $this->crud = 'Creative & Production Pathway';
            break;
        }

        return view('frontend.start')
            ->layout('layouts.frontend-ycm');
    }
    
    public function updatedFormEmail()
    {

        $email = $this->form->email ?? null;
        session()->flash('status', 'checking email ' . $email);

        if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $this->addError('form.email', 'Please enter a valid email address.');
            $this->emailExists = false;
            return;
        }
    
        $this->checkEmails();
    
        if ($this->emailExists) {
            // Instead of redirecting, just show the prompt in the view
            $this->addError('form.email', 'This email is already registered. You can log in below.');
        } else {
            // redirect to signup
            $email = urlencode($email);
            return redirect()->to('/signup/'.$this->venuedateid.'/'.$this->form->category.'/'.$email);
        }
        
    }



    private function checkEmails()
    {
        
       $email = $this->form->email ?? null;
       if (!empty($email)) {
            $this->emailExists = AuditioneeParent::where('email', $email)->exists();
        }
    }
    
    public function login()
    {
        $email = $this->form->email ?? null;
        if (Auth::guard('auditionee_parent')->attempt(['email' => $email, 'password' => $this->password])) {
            session()->regenerate();
            return redirect()->to('/profile/audition/'.$this->venuedateid.'/'.$this->form->category.'/'.$email);
        }

        $this->error = 'Invalid email or password.';
    }
    
    public function sendLoginLink()
    {
        if (!$this->form['email']) {
            return;
        }
    
        $email = $this->form['email'];
        
        // Generate the URL
        $link = url('/ycm/forgot-password?email=' . urlencode($email));
    
        // Send a basic email
        Mail::raw("You can continue your NYMT application by clicking this link: $link", function ($message) use ($email) {
            $message->to($email)
                    ->subject('Continue your NYMT application');
        });
    
        session()->flash('status', 'Login link sent to ' . $email);
    }

    
}