<?php
namespace App\Livewire\Frontend\Ycm;

use Illuminate\Support\Facades\Password;

use Livewire\Component;

class ParentForgotPassword extends Component
{
    public string $email = '';
    public string $status = '';

    public function sendResetLink()
    {
        $status = Password::broker('auditionee_parent')->sendResetLink([
            'email' => $this->email,
        ]);

        $this->status = __($status);
    }

    public function render()
    {
        return view('frontend.ycm.forgot-password')->layout('layouts.guest');
    }
}
