<?php
namespace App\Livewire\Frontend\Ycm;


use App\Models\Auditionee;
use App\Models\AuditioneeComment;
use App\Models\AuditioneeParent;
use App\Models\Audition;
use App\Models\CommentCategory;
use App\Models\Project;
use App\Models\Venue;
use App\Models\VenueDate;

use Livewire\Component;

use Illuminate\Validation\Rule;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\URL;

use App\Livewire\Frontend\Forms\UserForm;

class ParentProfile extends Component
{
    public UserForm $form;
    public $parent,$formType,$venuedate,$venuedateid = 0;

    public $crud, $password, $chosenvenue = false;
    public $venues,$projects,$venuedates,$commentcategories;
    public $showAddPostDialog = false;
    public $showAddCommentDialog = false;

    public $emailExists= false;


    public function mount(Request $request)
    {
        $this->parent = Auth::guard('auditionee_parent')->user();
        if ($request->formType) {
            $this->formType = $request->formType;
        }
        if ($request->applicationType) {
            $this->form->category = $request->applicationType;
        }
        if ($request->venue) {
            $this->venuedateid = $request->venue;
        }
        
    }


    public function render()
    {
        return view('frontend.ycm.parent-profile')
            ->layout('layouts.frontend-ycm');
    }
    
    public function newCourse($id = null)
    {
        if ($id) {
            $detailsUrl = URL::temporarySignedRoute(
                'ycm.course',
                now()->addDays(21),
                ['id' => $id]
            );
    
            return redirect()->to($detailsUrl);
        }
    
        return redirect()->route('ycm.course.guest');
    }

    
    public function newAudition($id = null)
    {
        $venue = $this->venuedateid ?? null;
        $applicationType = $this->form->category ?? null;
    
        // Normalize values
        $hasVenue = $venue && $venue > 0;
        $hasAppType = !empty($applicationType);
    
        // CASE 1: No auditionee
        if (!$id) {
            if ($hasVenue && $hasAppType) {
                return redirect()->route('ycm.audition.signup', [
                    'venue' => $venue,
                    'applicationType' => $applicationType,
                ]);
            } else {
                return redirect()->route('ycm.audition');
            }
        }
    
        // CASE 2: With auditionee
        $auditionee = Auditionee::find($id);
    
        if (!$auditionee) {
            session()->flash('error', 'Auditionee not found.');
            return redirect()->route('ycm.audition');
        }
    
        if ($hasVenue && $hasAppType) {
            $encodedEmail = urlencode(base64_encode($auditionee->email));
    
            return redirect()->route('ycm.audition.signupwithmail', [
                'venue' => $venue,
                'applicationType' => $applicationType,
                'email' => $encodedEmail,
            ]);
        }
    
        return redirect()->route('ycm.audition');
    }
}
