<?php
namespace App\Livewire\Frontend\Ycm;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Hash;

use Livewire\Component;

class ParentResetPassword extends Component
{
    public string $email = '';
    public string $token = '';
    public string $password = '';
    public string $password_confirmation = '';
    public string $status = '';

    public function mount($token)
    {
        $this->token = $token;
        $this->email = request('email', '');
    }

    public function resetPassword()
    {
        $status = Password::broker('auditionee_parent')->reset(
            [
                'email' => $this->email,
                'password' => $this->password,
                'password_confirmation' => $this->password_confirmation,
                'token' => $this->token,
            ],
            function ($user) {
                $user->forceFill([
                    'password' => Hash::make($this->password),
                ])->save();
            }
        );

        $this->status = __($status);
    }

    public function render()
    {
        return view('frontend.ycm.reset-password')->layout('layouts.guest');
    }
}
