<?php

namespace App\Livewire;

use App\Models\AuditioneeParent;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;

#[Layout('layouts.app')]
class Guardians extends Component
{
    use WithPagination;

    public string $search = '';
    public int $perPage = 20;

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function render()
    {
        $guardians = AuditioneeParent::with('auditionees')
            ->where(function ($query) {
                $query->where('firstname', 'like', "%{$this->search}%")
                      ->orWhere('lastname', 'like', "%{$this->search}%");
            })
            ->orderBy('lastname')
            ->paginate($this->perPage);

        return view('nymt.guardians', [
            'guardians' => $guardians
        ]);
    }
}