<?php

namespace App\Livewire\Project;

use Livewire\Component;
use Livewire\WithPagination;
use App\Mail\RoleOffer;
use App\Models\Auditionee;
use App\Models\Role;
use App\Models\Project;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Mail;

class RoleList extends Component
{
    use WithPagination;
    
    protected $queryString = ['sortField','sortDirection','view'];
    public $auditionee_id,$project_id, $project;
    

    public $isOpen = 0,   $inputsearch;
    public $view = 'list',$sortField = 'position', $sortDirection = 'asc', $perPage = '50';
    
    
    public function mount(Request $request)
    {
                if ($request->id) {
                    $this->project_id = $request->id;
                    $this->project = Project::find($this->project_id);
                }
        
    }

    public function render()

    {
        
        
        
        $query = Role::where('id','>',0);
    	$query->where('project_id','=',$this->project_id);
        
               // live filter
    	if(strlen($this->inputsearch)>=1){
    	    
    	    $searchResult = $this->inputsearch;
    	    
    		$query->where('name','like','%'.$searchResult.'%');
    	}
    	
    	
    	// deal with sortby
    	
    	    $query->orderBy($this->sortField,$this->sortDirection);

        return view('nymt.project.role-'.$this->view , [
            'myroles' => $query->paginate($this->perPage),
            ]);

    }
    
    
    public function sortBy($field){
        
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection ==='asc' ? 'desc' : 'asc';
        } else {
            $this->sortDirection ='asc';
        }
        
    $this->sortField = $field;
    }



    public function edit($id)

    {
        return redirect()->to('/auditionees/edit/'.$id);

    }

    public function sendOffer($id,$projectid)

    {
        
        $auditionee = Auditionee::find($id);
        
        if ($auditionee->secondary_email){
            Mail::to($auditionee->email)->cc($auditionee->secondary_email)->send(new RoleOffer($id,$projectid));
        } else {
            Mail::to($auditionee->email)->send(new RoleOffer($id,$projectid));
        }

        session()->flash('message', 'Role Offers Successfully sent to '.$auditionee->email.' .');


    }
}
