<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Project;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;

class Projects extends Component
{
    use WithPagination;
    
    protected $queryString = ['sortField','sortDirection'];
    public $project_id;
    
    public $isOpen = 0,  $template = 'grid', $inputsearch;
    public $sortField = 'name', $sortDirection = 'asc', $perPage = '20';
    
    public function render()

    {
        
        $query = Project::where('id','>',0);
        
        // live filter
    	if(strlen($this->inputsearch)>=1){
    	    
    	    $searchResult = $this->inputsearch;
    	    
    		$query->where('name','like','%'.$searchResult.'%');
    		$query->orwhere('type','like','%'.$searchResult.'%');
    	}
    	
    	// deal with sortby
    	
    	    $query->orderBy($this->sortField,$this->sortDirection);

        return view('nymt.projects', [
            'myprojects' => $query->paginate($this->perPage),
            ]);

    }
    
    
    public function sortBy($field){
        
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection ==='asc' ? 'desc' : 'asc';
        } else {
            $this->sortDirection ='asc';
        }
        
    $this->sortField = $field;
    }


    public function edit($id)

    {
        return redirect()->to('/projects/edit/'.$id);
    }

    public function delete($id)

    {
        $user = Project::find($id);
        $user->delete();

        session()->flash('message', 'Project Deleted Successfully.');

    }
    
    
    public function excerpt($text, $length)
    {
        return Str::limit($text, $length);
    }
    
    public function roles($id)

    {
        return redirect()->to('/roles/list/'.$id);
    }
    
    
}