<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Role;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;

class Roles extends Component
{
    use WithPagination;
    
    protected $queryString = ['sortField','sortDirection'];
    
    public $isOpen = 0,  $template = 'grid', $inputsearch, $projectsearch;
    public $sortField = 'project_id', $sortDirection = 'desc', $perPage = '20';
    

    public function render()
    {
        
        $query = Role::where('id','>',0);
        
               // live filter
    	if(strlen($this->inputsearch)>=1){
    	    
    	    $searchResult = $this->inputsearch;
    	    
    		//$query->with(['project' => function ($subquery) {
            //            $subquery->where('name','like','%bay%');
    	      //      }]);
    		$query->where('name','like','%'.$searchResult.'%');
    	
    	}
    	
    	if(strlen($this->projectsearch)>=1){
    	    $searchProject = $this->projectsearch;
    	    $query->whereRelation('project','name','like','%'.$searchProject.'%');
    	}
    	
    	$query->orderBy($this->sortField,$this->sortDirection);


        return view('nymt.roles', [
            'myroles' => $query->paginate($this->perPage),
            ]);

    }
    
    
    public function sortBy($field){
        
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection ==='asc' ? 'desc' : 'asc';
        } else {
            $this->sortDirection ='asc';
        }
        
    $this->sortField = $field;
    }


    public function edit($id)

    {
        return redirect()->to('/roles/edit/'.$id);

    }

    public function delete($id)

    {


        $user = Role::find($id);
        $user->delete();

        session()->flash('message', 'Role Deleted Successfully.');

    }
}