<?php

namespace App\Livewire\Venue;

use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\WithFileUploads;
use Illuminate\Validation\Rule;
use App\Livewire\Venue\Forms\DateForm;
use Illuminate\Http\Request;
use App\Models\Project;
use App\Models\Audition;

class EditDate extends Component
{
    use WithFileUploads;
    public DateForm $form;
    public $projects;
    public $showSuccessIndicator = false, $crud;

    public function mount(Request $request)
    {
                if ($request->id) {
                    $this->form->setVenueDate($request->id);
                } else {
                    if ($request->venue) {
                    $this->form->venue_id = $request->venue;
                    }
                    if ($request->project) {
                    $this->form->project_id = $request->venue;
                    }
                    $this->form->venue_date_id = false;
                    $this->form->start_date = date('Y-m-d');
                    $this->form->end_date = date('Y-m-d', strtotime('tomorrow'));
                }
    }

    public function save()
    {
        
        if ($this->form->venue_date_id){
            $message = "Updated";
        } else {
            $message = "Created";
        }
        $this->form->update();
        $this->crud = "Update";
        
        sleep(1);
        
        session()->flash('message', 'Venue Date '.$message.' Successfully.');

        //return redirect()->to('/venues/');
    }
    
    
    public function editAudition($id){
        return redirect()->to('/auditionees/edit/'.$id);
    }
    
    public function deleteAudition($id)
    {
        $audition = Audition::find($id);
        $audition->delete();
        session()->flash('message', 'Audition Deleted Successfully.');
    }
    

    public function render()
    {
        
        $this->crud = "Create";
        if ($this->form->venue_date_id){
        $this->crud = "Update";
        }
        return view('nymt.venue.dateedit');
    }
    
    
}