<?php

namespace App\Livewire\Venue\Forms;

use Livewire\Form;
use Livewire\WithFileUploads;
use Livewire\Attributes\Validate;
use Illuminate\Validation\Rule;
use Illuminate\Support\Str;
use App\Models\VenueDate;

class DateForm extends Form
{
    use WithFileUploads;
    
    public VenueDate $venuedate;
    #[Validate('required|min:3', onUpdate: false)]
    public $name= ''; 
    public $start_date = '';
    public $end_date =  '';
    public $start_time = '';
    public $end_time =  '';
    public $capacity = '';
    public $email_text = '';
    public $venue_id = null;
    public $project_id = null;
    public $margin = 0;
    public $musicians = 0;
    
    public $venue_date_id = false;
    
    

    public function setVenueDate($id)
    {
        
        $this->venuedate = VenueDate::find($id);
        
        if ($this->venuedate){
            
        $this->venue_date_id = $this->venuedate->id;
        $this->name = $this->venuedate->name;
        $this->start_date = date('Y-m-d' , strtotime($this->venuedate->start_date));
        $this->end_date = date('Y-m-d' , strtotime($this->venuedate->end_date));
        $this->start_time = $this->venuedate->start_time;
        $this->end_time = $this->venuedate->end_time;
        $this->capacity = $this->venuedate->capacity;
        $this->margin = $this->venuedate->margin;
        $this->musicians = $this->venuedate->musicians;
        $this->email_text = $this->venuedate->email_text;
        $this->venue_id = $this->venuedate->venue_id;
        $this->project_id = $this->venuedate->project_id;
        
        } 

    }
    

    public function update()
    {
        $this->validate();
        
        VenueDate::updateOrCreate(['id' => $this->venue_date_id], [
            'name' => $this->name,
            'start_date' => date('Y-m-d H:i:s' , strtotime($this->start_date)),
            'end_date' => date('Y-m-d H:i:s' , strtotime($this->end_date)),
            'start_time' => $this->start_time,
            'end_time' => $this->end_time,
            'capacity' => $this->capacity,
            'margin' => $this->margin,
            'musicians' => $this->musicians,
            'email_text' => $this->email_text,
            'venue_id' => $this->venue_id,
            'project_id' => $this->project_id
        ]);
        
    }
}