<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Venue;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;

class Venues extends Component
{
    use WithPagination;
    
    protected $queryString = ['sortField','sortDirection'];
    public $venue_id;
    
    public $isOpen = 0,  $template = 'grid', $inputsearch;
    public $sortField = 'name', $sortDirection = 'asc', $perPage = '20';
    
    public function render()

    {
        
        $query = Venue::where('id','>',0);
        
               // live filter
    	if(strlen($this->inputsearch)>=1){
    	    
    	    $searchResult = $this->inputsearch;
    	    
    		$query->where('name','like','%'.$searchResult.'%');
    		$query->orwhere('town','like','%'.$searchResult.'%');
    	}
    	
    	
    	// deal with sortby
    	
    	    $query->orderBy($this->sortField,$this->sortDirection);


        return view('nymt.venues', [
            'myvenues' => $query->paginate($this->perPage),
            ]);

    }
    
    
    public function sortBy($field){
        
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection ==='asc' ? 'desc' : 'asc';
        } else {
            $this->sortDirection ='asc';
        }
        
    $this->sortField = $field;
    }


    public function edit($id)

    {
        return redirect()->to('/venues/edit/'.$id);

    }

    public function delete($id)

    {


        $user = Venue::find($id);
        $user->delete();

        session()->flash('message', 'Venue Deleted Successfully.');

    }
}