<?php

namespace App\Mail;

use App\Models\Auditionee;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\URL;


class AuditionPaid extends Mailable


{
    use Queueable, SerializesModels;
    
    public Auditionee $auditionee;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(private $auditionee_id)
    {
        
        $this->auditionee = Auditionee::find($auditionee_id);
        //
    }

    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */

    public function envelope()
    {
        return new Envelope(
            subject: 'NYMT | Thank you for paying – your audition workshop day is confirmed',
        );
    }
 /**
     * Get the message content definition.
     *
     * @return \Illuminate\Mail\Mailables\Content
     */

    public function content(): Content
    {
        
        $firstname = $this->auditionee->firstname;
        $lastname = $this->auditionee->lastname;
        
        $venue_address = $this->auditionee->audition->venue_date->venue->address."<br />".$this->auditionee->audition->venue_date->venue->town."<br />".$this->auditionee->audition->venue_date->venue->postcode;
        
        
        $template = 'emails.frontend.audition-paid';
        if ($this->auditionee->category == 'musician'){
            $template = 'emails.frontend.audition-musician-paid';
        }
        
        
        return new Content(
            markdown: $template,
            with: [
                'firstname' => $firstname,
                'lastname' => $lastname,
                'venue_website' => $this->auditionee->audition->venue_date->venue->website,
                'venue_name' => $this->auditionee->audition->venue_date->venue->name,
                'venue_address' => $venue_address,
                'audition_date' => date('Y-m-d' , strtotime($this->auditionee->audition->venue_date->start_date)),
                'audition_start_time' => $this->auditionee->audition->venue_date->start_time,
                'audition_end_time' => $this->auditionee->audition->venue_date->end_time,
                'audition_email_text' => $this->auditionee->audition->venue_date->email_text,
                'age' => $this->auditionee->age
            ],
        );
    }
    

    /**
     * Get the attachments for the message.
     *
     * @return array
     */
    public function attachments()
    {
        return [];
    }
}