<?php

namespace App\Mail;

use App\Models\Auditionee;
use App\Models\Course;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\URL;


class CoursePaid extends Mailable


{
    use Queueable, SerializesModels;
    
    public Auditionee $auditionee;
    public Course $course;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(private $auditionee_id,private $course_id)
    {
        
        $this->auditionee = Auditionee::find($auditionee_id);
        $this->course = Course::find($course_id);
        //
    }

    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */

    public function envelope()
    {
        return new Envelope(
            subject: 'NYMT | Thank you for paying – your NYMT course booking is confirmed',
        );
    }
 /**
     * Get the message content definition.
     *
     * @return \Illuminate\Mail\Mailables\Content
     */

    public function content(): Content
    {
        

        $firstname = $this->auditionee->firstname;
        $lastname = $this->auditionee->lastname;
        $course = $this->course;
        
        
        
        return new Content(
            markdown: 'emails.frontend.course-paid',
            with: [
                'firstname' => $firstname,
                'lastname' => $lastname,
                'course_name' => $course->name,
                'course_location' => $course->location,
                'course_email_text' => $course->email_text,
            ],
        );
    }
    

    /**
     * Get the attachments for the message.
     *
     * @return array
     */
    public function attachments()
    {
        return [];
    }
}