<?php

namespace App\Mail;

use App\Models\Auditionee;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\URL;


class PaypalSuccess extends Mailable


{
    use Queueable, SerializesModels;
    
    public Auditionee $auditionee;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(private $auditionee_id)
    {
        
        $this->auditionee = Auditionee::find($auditionee_id);
        //
    }

    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */

    public function envelope()
    {
        return new Envelope(
            subject: 'Application to NYMT Paid',
        );
    }
 /**
     * Get the message content definition.
     *
     * @return \Illuminate\Mail\Mailables\Content
     */

    public function content(): Content
    {
        
        $detailsUrl = URL::signedRoute('auditionee.details', [
            'id' => $this->auditionee->id,
        ]);
        
        return new Content(
            markdown: 'emails.frontend.paypal-success',
            with: [
                'detailsUrl' => $detailsUrl,
            ],
        );
    }
    

    /**
     * Get the attachments for the message.
     *
     * @return array
     */
    public function attachments()
    {
        return [];
    }
}