<?php

namespace App\Mail;

use App\Models\Auditionee;
use App\Models\Project;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\URL;


class RoleAccepted extends Mailable


{
    use Queueable, SerializesModels;
    
    public Auditionee $auditionee;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(private $auditionee_id,private $project_id)
    {
        
        $this->auditionee = Auditionee::find($auditionee_id);
        $this->project = Project::find($project_id);
        //
    }

    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */

    public function envelope()
    {
        return new Envelope(
            subject: 'NYMT | You have accepted your Role',
        );
    }
 /**
     * Get the message content definition.
     *
     * @return \Illuminate\Mail\Mailables\Content
     */

    public function content(): Content
    {
        
        
        $firstname = $this->auditionee->firstname;
        $lastname = $this->auditionee->lastname;
        
        $castrole = "";
        $project = "";
        
        $roles = $this->auditionee->roles;
            if ($roles) {
                foreach ($roles as $role){
                    if ($role->role->project_id == $this->project->id) { // can they have more than one role in same project?
                        $castrole = $role->role->name;
                        $project = $role->role->project->name;
                    }
                }
            } 
        
        
        return new Content(
            markdown: 'emails.frontend.role-accepted',
            with: [
                'role' => $castrole,
                'firstname' => $firstname,
                'lastname' => $lastname,
                'project' => $project,
            ],
        );
    }
    

    /**
     * Get the attachments for the message.
     *
     * @return array
     */
    public function attachments()
    {
        return [];
    }
}