<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class Audition extends Model
{
    
    use HasFactory;
      

    protected $guarded = [];
    
    
    public function auditionee(){
       return $this->belongsTo(Auditionee::class);
    }
    public function venue_date(){
       return $this->belongsTo(VenueDate::class);
    }
    public function score(){
       return $this->hasOne(AuditionScore::class);
    }
    
    
    public function transaction(){
       return $this->belongsTo(AuditioneeTransaction::class, 'auditionee_transaction_id');
    }
    
    public function paid(){
        if ($this->transaction){
            return "Yes - £".$this->transaction->amount;
        } else {
            return "Not yet";
        }
    }
    
    public function next(){
        return Audition::where('id', '>', $this->id)
            ->where('venue_date_id', '=', $this->venue_date_id)
            ->orderBy('id','asc')
            ->first();
    }
    public function previous(){
        return Audition::where('id', '<', $this->id)
            ->where('venue_date_id', '=', $this->venue_date_id)
            ->orderBy('id','desc')
            ->first();
    }
}