<?php

namespace App\Providers;

use App\Actions\Jetstream\AddTeamMember;
use App\Actions\Jetstream\CreateTeam;
use App\Actions\Jetstream\DeleteTeam;
use App\Actions\Jetstream\DeleteUser;
use App\Actions\Jetstream\InviteTeamMember;
use App\Actions\Jetstream\RemoveTeamMember;
use App\Actions\Jetstream\UpdateTeamName;
use Illuminate\Support\ServiceProvider;
use Laravel\Jetstream\Jetstream;

class JetstreamServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        $this->configurePermissions();

        Jetstream::createTeamsUsing(CreateTeam::class);
        Jetstream::updateTeamNamesUsing(UpdateTeamName::class);
        Jetstream::addTeamMembersUsing(AddTeamMember::class);
        Jetstream::inviteTeamMembersUsing(InviteTeamMember::class);
        Jetstream::removeTeamMembersUsing(RemoveTeamMember::class);
        Jetstream::deleteTeamsUsing(DeleteTeam::class);
        Jetstream::deleteUsersUsing(DeleteUser::class);
    }

    /**
     * Configure the roles and permissions that are available within the application.
     */
    protected function configurePermissions(): void
    {
        Jetstream::defaultApiTokenPermissions(['read']);


        Jetstream::role('superadmin', 'Super Administrator', [
            'create',
            'read',
            'csv-all',
            'delete',
            'pastoral',
            'scores',
            'payments',
        ])->description('Super Administrator can create new team members.');
        
        Jetstream::role('admin', 'Administrator', [
            'create',
            'read',
            'pastoral',
            'scores',
            'payments',
        ])->description('Administrator users can perform any action except manage new team members.');

        Jetstream::role('editor', 'Creative Staff', [
            'read',
            'scores',
            'creativestaffonly'
        ])->description('Creative Staff do not have access to most pastoral/personal information.');
        
        Jetstream::role('pastoral', 'Pastoral Staff', [
            'read',
            'pastoral',
            'pastoralstaffonly',
        ])->description('Pastoral Staff have the ability to read Pastoral items and see help text for registrations.');
        
        Jetstream::role('core', 'Core Staff', [
            'read',
            'pastoral',
            'scores',
            'payments',
        ])->description('Core Staff have the ability to read Pastoral items but do not see pastoral-only interface messages.');
        
        Jetstream::role('readonly', 'Read Only', [
            'read',
        ])->description('This role has very limited read-only access to non-sensitive information.');
        
        Jetstream::role('paused', 'Paused', [
            'read',
        ])->description('This account is paused and does not have access to information.');
        
    }
}
