@props([
    'leadingAddOn' => false,
    'trailingAddOn' => false,
    'label' => false,
    'showcurrency' => false,
    'infotext' => false,
    'date' => false,
])


    @if ($label)
    <x-nymt.input.label {{ $attributes->merge(['class' => 'textlabel']) }}>{{ $label }}</x-nymt.input.label>
    @endif
    @if ($infotext)
        <x-nymt.input.infotext>{{ $infotext }}</x-nymt.input.infotext>
    @endif

<div class="flex rounded-md px-3 py-2 rounded-lg">
    @if ($showcurrency)
        <span class="inline-flex items-center px-3 rounded-l-md border border-r-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm">
            £
        </span>
    @elseif ($leadingAddOn)
        <span class="inline-flex min-w-[120px] items-center px-3 rounded-l-md border border-r-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm">
            {{ $leadingAddOn }}
        </span>
    @endif

    <input {{ $attributes->merge(['class' => 'flex-1 px-3 py-2 rounded-lg form-input border-gray-300 block w-full transition duration-150 ease-in-out sm:text-sm sm:leading-5' . ($leadingAddOn ? ' rounded-none rounded-r-md' : '') . ($showcurrency ? ' rounded-none rounded-r-md' : '') . ($trailingAddOn ? ' rounded-none rounded-l-md text-right' : '')]) }}
    
            @if ($date)
                type="date"
            @endif
    />
    
    @if ($trailingAddOn)
        <span class="inline-flex items-center px-3 rounded-r-md border border-l-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm">
            {{ $trailingAddOn }}
        </span>
    @endif
</div>