@props(['active','navlink' => false,'align' => 'left', 'width' => '60', 'contentClasses' => 'py-1 bg-white'])

@php
$classes = ($active ?? false)
            ? 'inline-flex items-center px-1 pt-1 border-b-2 border-indigo-400 text-sm font-medium leading-5 text-gray-900 focus:outline-none focus:border-indigo-700 transition duration-150 ease-in-out'
            : 'inline-flex items-center px-1 pt-1 border-b-2 border-transparent text-sm font-medium leading-5 text-gray-500 hover:text-gray-700 hover:border-gray-300 focus:outline-none focus:text-gray-700 focus:border-gray-300 transition duration-150 ease-in-out';
            
            
switch ($align) {
    case 'left':
        $alignmentClasses = 'origin-top-left';
        break;
    case 'top':
        $alignmentClasses = 'origin-top';
        break;
    case 'right':
    default:
        $alignmentClasses = 'origin-top-right right-0';
        break;
}

switch ($width) {
    case '60':
        $width = 'w-60';
        break;
}

$onclick = ($navlink ?? true) ? "window.location = '".$navlink."'" : 'open = ! open';
            
@endphp

    <div {{ $attributes->merge(['class' => $classes]) }} x-data="{ open: false }" @click.away="open = false" @close.stop="open = false" @mouseover="open = ! open" @mouseout="open = false"  @click="{{ $onclick }}">
    
        {{ $trigger }}

    <div class="relative">
    <div x-show="open"
            x-transition:enter="transition ease-out duration-200"
            x-transition:enter-start="transform opacity-0 scale-95"
            x-transition:enter-end="transform opacity-100 scale-100"
            x-transition:leave="transition ease-in duration-75"
            x-transition:leave-start="transform opacity-100 scale-100"
            x-transition:leave-end="transform opacity-0 scale-95"
            class="absolute z-50 mt-8 {{ $width }} rounded-md shadow-lg {{ $alignmentClasses }}"
            style="display: none; left: -2rem "
            @click="open = false">
        <div class="rounded-md shadow-xs {{ $contentClasses }}">
            {{ $content }}
        </div>
    </div>
    </div>
</div>