@props([
    'sortable' => null,
    'draggable' => null,
    'class' => '', // New prop for custom styling classes
])

<table {{ $attributes->merge(['class' => "table-auto w-full text-xs rounded-lg shadow-md overflow-hidden $class"]) }}>

    <thead>
        <tr class="bg-gray-100 border text-left">
            {{ $head }}
        </tr>
    </thead>

    <tbody 
        @if ($sortable)
            wire:sortable="{{ $sortable }}"
        @endif
        @if ($draggable)
            x-sort="$wire.sortItem($item, $position)"
        @endif
    >
        {{ $body }}
    </tbody>

</table>