@props([
    'sortable' => null,
    'direction' => null,
    'multiColumn' => null,
    ])
    
<th 
{{ $attributes->merge(['class' => 'px-2 py-2 bg-cool-grey-50 font-bold']) }}
>
    @unless ($sortable)
        <span class="bg-cool-grey-50 font-bold">{{ $slot }}</span>
    @else
    
    <button class="flex items-center space-x-1 bg-cool-grey-50 font-bold text-left">
        <span class="">{{ $slot }}</span>
        
            <span class="relative flex items-center">
                @if ($multiColumn)
                    @if ($direction === 'asc')
                        <svg class="w-3 h-3 group-hover:opacity-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7"></path></svg>
                        <svg class="w-3 h-3 opacity-0 group-hover:opacity-100 absolute" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                    @elseif ($direction === 'desc')
                        <div class="opacity-0 group-hover:opacity-100 absolute">
                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7"></path></svg>
                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                        </div>
                        <svg class="w-3 h-3 group-hover:opacity-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                    @else
                    <x-nymt.icon.up class="opacity-0 group-hover:opacity-100 transition-opacity duration-300" />
                    @endif
                @else
                    @if ($direction === 'asc')
                    <x-nymt.icon.down />
                    @elseif ($direction === 'desc')
                    <x-nymt.icon.up />
                    @else
                    <x-nymt.icon.up class="opacity-0 group-hover:opacity-100 transition-opacity duration-300" />
                    @endif
                @endif
            </span>

    </button>
    
    @endunless

</th>