<!-- Tabs -->
<div
    x-data="{
        selectedId: null,
        init() {
            // Set the first available tab on the page on page load.
            this.$nextTick(() => this.select(this.$id('tab', 1)))
        },
        select(id) {
            this.selectedId = id
        },
        isSelected(id) {
            return this.selectedId === id
        },
        whichChild(el, parent) {
            return Array.from(parent.children).indexOf(el) + 1
        }
    }"
    x-on:livewire-step-validated.window="select($event.detail.tab)"
    x-id="['tab']"
    class="mx-auto w-full max-w-3xl"
>
    <!-- Tab List -->
    <ul
        x-ref="tablist"
        @keydown.right.prevent.stop="$focus.wrap().next()"
        @keydown.home.prevent.stop="$focus.first()"
        @keydown.page-up.prevent.stop="$focus.first()"
        @keydown.left.prevent.stop="$focus.wrap().prev()"
        @keydown.end.prevent.stop="$focus.last()"
        @keydown.page-down.prevent.stop="$focus.last()"
        role="tablist"
        class="-mb-px flex items-stretch"
    >
        <!-- Tab -->
        
                        {{ $head }}


    </ul>
    <!-- Panels -->
    <div role="tabpanels" class="bg-white">
         
            <div class="flex flex-col gap-4 bg-white">
                        {{ $body }}        
            </div>

    </div>
</div>