@component('mail::message')

Hello {{ $firstname }}, 

Thank you for your application to become a young company member of NYMT’s 2025 season. We look forward to seeing you at the audition workshop day. 

When you arrive, please sign in with our friendly pastoral team. They are there to look after you and will be a main point of contact for you if you need any support or have any questions. 

<h3>Date and time:</h3>

{{ date('l, j F Y', strtotime($audition_date)) }}

Start time: {{ date('g:ia', strtotime($audition_start_time)) }}<br>
End time: {{ date('g:ia', strtotime($audition_end_time)) }}<br>

Registration opens half an hour before the start time above. 

<h3>Location:</h3>

{{ $venue_name }}  
{!! $venue_address !!}

{{ $venue_website }}  


<h3>What to prepare:</h3>

The workshop will involve you taking part in one session each of singing, acting, and dance/movement.

For the singing session, please prepare a song from a piece of musical theatre. It’s most practical for the pianist if you bring the music printed single sided and sellotaped together, but don’t worry if you can’t do this. 

For the acting session, we’ve provided some scripts for you to look at ahead of time – <a href="https://www.dropbox.com/scl/fo/dtrpa0hhzjlk4821rh3q7/APhsjCL7msgPDS-8ofofXJs?rlkey=swpq7dfe37ni3prflvvkar7kt&e=1&st=imyiw0o3&dl=1">you can download it here</a>. You don’t need to learn any of this in advance. It is also not designed as a reading test! You will be allowed to hold the script at all times while we direct you as we would in one of our productions. Copies will be provided on the day, but if you'd prefer to highlight lines or make notes then please do bring a copy for yourself.

Finally, for the dance/movement session, you don’t need to prepare anything in advance. 

<h3>What to wear and what to bring:</h3>

Wear clothes and shoes you feel comfortable moving in. 

Please bring a bottle of water to keep yourself hydrated. 

You will need to bring a packed lunch with you as it won’t be possible to go out to get lunch. You are also welcome to bring snacks for breaks during the day, but you mustn’t bring anything that contains nuts. 


<h3>Other information</h3>

{!! $audition_email_text !!}  

We hope you’re looking forward to the day just as much as we’re looking forward to seeing you. Most of all, remember that we want these workshops to be fun for everyone. So please enjoy every aspect of the day, and if there’s anything we can do to make this experience a more positive one, do tell us. 

Finally, we think you're {{ $age }} years old, based on the date of birth you gave us. If this isn't right, please let us know.

Best wishes, 

<b>Team NYMT</b> 
enquiries@nymt.org.uk 

@endcomponent