    <div class="">
        <div class="relative sm:flex sm:justify-center sm:items-center min-h-screen bg-dots-darker bg-center dark:bg-dots-lighter dark:bg-gray-900 selection:bg-red-500 selection:text-white">
            
            <div class="bg-white rounded-xl shadow p-8 flex flex-col gap-6 min-w-[35rem]">
                @if ($message = Session::get('success'))
            
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>{{ $message }}</strong>
                </div>
                
                
                <div>
                    <p class="pb-2">Thank you for booking, {{ $ycm->firstname }}.</p>
                    <p class="pb-2">Please now check your email for further information.</p>
                
                
                    <x-nymt.html.subtitle>Course Booked</x-nymt.html.subtitle>
                    <x-nymt.html.h4title>{{$course->name }}</x-nymt.html.h4title>
                    <x-nymt.html.h4title>{{ date('d F' , strtotime($course->start_date)) }} – {{ date('d F Y' , strtotime($course->end_date)) }}</x-nymt.html.h4title>
                </div>


                <img src="/media/images/NYMT_Logo_Full_Colour.png" style="width:500px">


                @elseif ($message = Session::get('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <strong>{{ $message }}</strong>
                </div>
                
                @else    
                <div>
                    <p>Thanks! Your booking information has been submitted.</p>
                
                
                    <x-nymt.html.h4title>{{$course->name }}</x-nymt.html.h4title>
                    <x-nymt.html.h4title>{{ date('d F' , strtotime($course->start_date)) }} – {{ date('d F Y' , strtotime($course->end_date)) }}</x-nymt.html.h4title>
                    <x-nymt.html.h4title>Price: &pound;{{$course->price }}</x-nymt.html.h4title>
                
                    <p class="pb-2">Please click on the link below to pay for your course.</p>
                    <p class="pb-2">Your booking will not be complete until you have paid.</p>
                    <!--<p class="pb-2">We also offer payment plans. Please <a href="mailto:enquiries@nymt.org.uk?subject=Course%20Payment%20Plan%20enquiry" style="text-decoration: underline;">get in touch with us</a> if you'd like more information.</p>-->

                    <center>
                        <x-nymt.button.primary wire:click="payment()">Pay with PayPal</x-nymt.button.primary>
                    </center>
                </div>
                @endif
            </div>
        </div>
    </div>