  <x-slot name="header">
    <div class="flex">
        <div>
            <x-nymt.html.title>{{ $crud }}</x-nymt.html.title>
        </div>
    </div>

    </x-slot>

    <x-nymt.body>

    <div class="grid grid-cols-1">
            

    <x-nymt.tabs.alt>
        <x-slot name="head">
            <x-nymt.tabs.label-alt>1</x-nymt.tabs.label-alt>
            @if ($steps[1])
            <x-nymt.tabs.label-alt>2</x-nymt.tabs.label-alt>
            @endif
            @if ($steps[2])
            <x-nymt.tabs.label-alt>3</x-nymt.tabs.label-alt>
            @endif
            @if ($steps[3])
            <x-nymt.tabs.label-alt>4</x-nymt.tabs.label-alt>
            @endif
            @if ($steps[4])
            <x-nymt.tabs.label-alt>5</x-nymt.tabs.label-alt>
            @endif
            @if ($steps[5])
            <x-nymt.tabs.label-alt>6</x-nymt.tabs.label-alt>
            @endif
            @if ($steps[6])
            <x-nymt.tabs.label-alt>7</x-nymt.tabs.label-alt>
            @endif
            @if ($steps[7])
            <x-nymt.tabs.label-alt>8</x-nymt.tabs.label-alt>
            @endif
            @if ($steps[8])
            <x-nymt.tabs.label-alt>9</x-nymt.tabs.label-alt>
            @endif
            @if ($steps[9])
            <x-nymt.tabs.label-alt>10</x-nymt.tabs.label-alt>
            @endif
            @if ($steps[10])
            <x-nymt.tabs.label-alt>11</x-nymt.tabs.label-alt>
            @endif
        </x-slot>

        <x-slot name="body">      
            <x-nymt.tabs.section class="p-1">   
                <x-nymt.html.subtitle>Section 1: Personal Information</x-nymt.html.subtitle>
                <x-nymt.input.text class="required" label="First Name" placeholder="Enter First Name" infotext="Enter the name you'd like to be known by" wire:model.blur="form.firstname"></x-nymt.input.text>
                @error('form.firstname')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Last Name" placeholder="Enter Last Name" wire:model.blur="form.lastname" infotext=""></x-nymt.input.text>
                @error('form.lastname')   <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text label="Formal Name" placeholder="Enter Formal Name" wire:model.blur="form.formalname" infotext="If you have a name you'd prefer us to use in public-facing material, like programmes, please enter it here."></x-nymt.input.text>
                <x-nymt.input.select class="required" model="form.gender" label="Gender">
                <option value="" selected>Please select</option>
                <x-nymt.options.gender></x-nymt.options.gender>
                </x-nymt.input.select>
                @error('form.gender') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Date of Birth" wire:model.blur="form.dob" date infotext="Please ensure you input the correct year of birth. You may find it easier to type in your date of birth."></x-nymt.input.text>
                @error('form.dob') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Main Contact Email" placeholder="Enter Email" wire:model.blur="form.email" infotext="We'll send our contact emails here. For children under 18, this should be a parent or carer's address."></x-nymt.input.text>
                @error('form.email')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text label="Secondary Contact Email" placeholder="Enter Email" wire:model.blur="form.secondary_email" infotext="Optional. We’ll send a copy of our general information emails here too."></x-nymt.input.text>
                @error('form.secondary_email')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                
                @if ($emailsMatchError)
                    <x-nymt.input.error>The secondary email cannot be the same as the main contact email.</x-nymt.input.error>
                @endif
                
                <div wire:loading.delay class="inline-flex pl-4 pr-4">
                    <svg class="animate-spin h-5 w-5 text-black" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
                <div class="text-center">
                <x-nymt.button wire:click="validateStep(1)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section> 
            <x-nymt.tabs.section class="p-1">   
                <x-nymt.html.subtitle>Section 2: Personal Information</x-nymt.html.subtitle>
                <x-nymt.input.text label="Mobile Number" placeholder="Enter Mobile Number" wire:model.blur="form.tel" infotext="Optional. This is the contact number for the auditionee, if applicable. There's an opportunity to add an emergency/parent contact number later."></x-nymt.input.text>
                @error('form.tel') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Street Address" placeholder="Enter Street Address" wire:model.blur="form.address"></x-nymt.input.text>
                @error('form.address') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Town / City" placeholder="Enter Town / City" wire:model.blur="form.town"></x-nymt.input.text>
                @error('form.town') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Postcode" placeholder="Enter Postcode" wire:model.blur="form.postcode"></x-nymt.input.text>
                @error('form.postcode') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.select class="required" label="Country" model="form.country">
                    <option value="" selected>Choose your country</option>
                    @foreach (App\Enums\Country::cases() as $country)
                    <option value="{{ $country->value }}">{{ $country->label() }}</option>
                    @endforeach
                </x-nymt.input.select>
                @error('form.country') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text type="file" class="required" label="Photo" wire:model.blur="form.photo" infotext="Please upload a recent informal photo to help us recognise you. The photo should be your head and shoulders only. We will not use this photo in public. We cannot currently accept HEIC files: please convert to JPEG before uploading."></x-nymt.input.text>
                @error('form.photo') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                
                @if ($form->photo && $form->photo->temporaryUrl()) 
                    <div class="text-center"><img src="{{ $form->photo->temporaryUrl() }}" width="200"></div>
                    @endif
                
                <div class="text-center">
                <x-nymt.button @click="select('tab-1-1')" class="text-center">Back</x-nymt.button>
                
                <x-nymt.button wire:click="validateStep(2)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section> 
            <x-nymt.tabs.section class="p-1">   
                <x-nymt.html.subtitle>Section 3: Emergency Contact Information</x-nymt.html.subtitle>
                <x-nymt.input.text class="required" label="Emergency Contact Name" placeholder="Enter Emergency Contact Name" wire:model.blur="form.emergency_contact"></x-nymt.input.text>
                @error('form.emergency_contact')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Relationship to You" placeholder="Enter Emergency Contact Relationship" wire:model.blur="form.emergency_relationship" infotext="e.g. 'Mother'"></x-nymt.input.text>
                @error('form.emergency_relationship')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Emergency Tel" placeholder="Enter Emergency Tel" wire:model.blur="form.emergency_tel"></x-nymt.input.text>
                @error('form.emergency_tel')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror



                <div class="text-center">
                <x-nymt.button @click="select('tab-1-2')" class="text-center">Back</x-nymt.button>
                <x-nymt.button wire:click="validateStep(3)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section> 
            <x-nymt.tabs.section class="p-1">   
                <x-nymt.html.subtitle>Section 4: Experience</x-nymt.html.subtitle>
            @if ($form->category == "actor")
                <x-nymt.input.select class="required" label="Voice" infotext="Which voice part best describes your range?" model="form.singing_experience">
                    <option value="" selected>Select your voice part</option>
                    <x-nymt.options.singing_experience></x-nymt.options.singing_experience>
                </x-nymt.input.select>
       
                <x-nymt.html.subtitle>Dance</x-nymt.html.subtitle>
                <x-nymt.input.infotext>Do you have experience in any of the following? Please tick all that apply</x-nymt.input.infotext>
                <x-nymt.input.checkboxform name="form.dancing_experience[]" wire:model="form.dancing_experience" value="Ballet" label="Ballet"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dancing_experience[]" wire:model="form.dancing_experience" value="Tap" label="Tap"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dancing_experience[]" wire:model="form.dancing_experience" value="Jazz" label="Jazz"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dancing_experience[]" wire:model="form.dancing_experience" value="Contemporary" label="Contemporary"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dancing_experience[]" wire:model="form.dancing_experience" value="Latin/Ballroom" label="Latin/Ballroom"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dancing_experience[]" wire:model="form.dancing_experience" value="Street/Hip Hop" label="Street/Hip Hop"></x-nymt.input.checkboxform>
                
                <x-nymt.input.textarea label="Musical Instruments" infotext="If you play any musical instruments, please enter the instrument(s) followed by a grade or level if appropriate. e.g. Flute (3), Organ (FRCO)" placeholder="If none, leave box empty." wire:model.blur="form.musical_instruments" maxlength="1000"></x-nymt.input.textarea>
                <x-nymt.input.textarea label="Previous Performance Experience" infotext="If you have any previous performance experience that you’d like to tell us about, tell us briefly, in no more than a few sentences, here." placeholder="If none, leave box empty." wire:model.blur="form.acting_experience" rows="4" maxlength="1000"></x-nymt.input.textarea>
                <x-nymt.input.textarea label="Special Skills" infotext="Do you have any special skills, e.g. circus skills or martial arts? Please give details & skill level." placeholder="If none, leave box empty." wire:model.blur="form.special_skills" maxlength="1000"></x-nymt.input.textarea>
            @endif    
            @if ($form->category == "musician")
                <x-nymt.input.text label="Self-tape Video Link" infotext="You do not need to provide a self-tape unless we’ve specifically asked you to." wire:model.blur="form.profile_video_path"></x-nymt.input.text>
                <x-nymt.input.textarea label="Musical Instruments and Grades" infotext="Please list the musical instrument(s) you intend to audition on followed by a grade or level if appropriate. e.g. Flute (6), Saxophone (7). You are then welcome to list any other instruments you think we might like to know about, if you like." wire:model.blur="form.musical_instruments" maxlength="1000"></x-nymt.input.textarea>
                <x-nymt.input.textarea label="Performance Experience" infotext="Tell us briefly about any relevant performance experience that you have." wire:model="form.acting_experience" rows="4" maxlength="1000"></x-nymt.input.textarea>
            @endif    
            @if ($form->category == "cpp")
                <x-nymt.input.select class="required" label="Which role are you most interested in?" model="form.nymt_role" xmodel="experience" >
                    <option value="" selected>Please choose</option>
                    <x-nymt.options.nymt_ctms></x-nymt.options.nymt_ctms>
                </x-nymt.input.select>
                
                <x-nymt.input.textarea class="required w-full" label="Experience" infotext="Tell us briefly about any relevant experience that you have." wire:model.blur="form.acting_experience" rows="8" maxlength="1000"></x-nymt.input.textarea>
                
            @endif    
         
         
                <div class="text-center">
                <x-nymt.button @click="select('tab-1-3')" class="text-center">Back</x-nymt.button>
                <x-nymt.button wire:click="validateStep(4)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section>  
            <x-nymt.tabs.section class="p-1" x-data="{ experience: false,noexperience : false  }">   
                
                <x-nymt.html.subtitle>Section 5: Your NYMT Experience</x-nymt.html.subtitle>
                <x-nymt.input.select class="required" label="Have you taken part in an NYMT project before?" model="form.nymt_experience" xmodel="experience" >
                    <option value="" selected>Please choose</option>
                    <x-nymt.options.nymt_experience></x-nymt.options.nymt_experience>
                </x-nymt.input.select>
                
                <div x-show="experience == 0">
                <x-nymt.input.select label="How did you hear about NYMT?" model="form.nymt_experience_no" xmodel="noexperience">
                    <option value="" selected>Please choose</option>
                    <x-nymt.options.nymt_experience_no></x-nymt.options.nymt_experience_no>
                </x-nymt.input.select>
                <div x-show="noexperience == 'Other'">
                <x-nymt.input.text label="Other" placeholder="Enter Other" wire:model.blur="form.nymt_experience_no_other"></x-nymt.input.text>
                </div>
                </div>
                
                <div x-show="experience != 0">
                <x-nymt.input.textarea label="Which projects have you been involved in with NYMT? Briefly list them here." wire:model.blur="form.nymt_experience_yes" rows="4" maxlength="1000"></x-nymt.input.textarea>
                </div>
                
                
                <div class="text-center">
                <x-nymt.button @click="select('tab-1-4')" class="text-center">Back</x-nymt.button>
                <x-nymt.button wire:click="validateStep(5)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section>  
            <x-nymt.tabs.section class="p-1">   
                
                <x-nymt.html.subtitle>Section 6: Health and Access</x-nymt.html.subtitle>
                <x-nymt.input.textarea label="Allergy Information" wire:model="form.pastoral_allergies" infotext="Tell us about any allergies you have. Please include usual treatment." rows="4" placeholder="If none, leave box empty." maxlength="1000"></x-nymt.input.textarea>
                <x-nymt.input.select label="I use an adrenaline auto-injector (Epipen or similar)" model="form.pastoral_epipen" infotext="If you select yes, please bring two if you have two and make yourself known to staff on arrival.">
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                <x-nymt.input.select label="I use an inhaler" model="form.pastoral_inhaler" infotext="If you select yes, please bring a spare.">
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                
                <x-nymt.input.textarea label="Accessibility" wire:model="form.pastoral_barriers" rows="4" infotext="We strive to make NYMT somewhere that is inclusive and accessible for all. If you have accessibility needs, please let us know here." placeholder="If none, leave box empty." maxlength="1000"></x-nymt.input.textarea>
                
                <x-nymt.input.select label="Disability" model="form.pastoral_disability" infotext="Do you have a disability in accordance with the terms of the Disability Discrimination Act 2005?">
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                
                <div class="text-center">
                <x-nymt.button @click="select('tab-1-5')" class="text-center">Back</x-nymt.button>
                <x-nymt.button wire:click="validateStep(6)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section>  
            <x-nymt.tabs.section class="p-1">   
                
                <x-nymt.html.subtitle>Section 7: Availability</x-nymt.html.subtitle>
                <p>Please list any dates during the school holidays over the next 12 months when you would not be able to attend NYMT activities.</p>
                <x-nymt.input.text wire:model.blur="form.unavailability" placeholder="If none, leave box empty." maxlength="1000"></x-nymt.input.text>
                <div class="text-center">
                <x-nymt.button @click="select('tab-1-6')" class="text-center">Back</x-nymt.button>
                <x-nymt.button wire:click="validateStep(7)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section>  
            <x-nymt.tabs.section class="p-1" x-data="{ filmpermission : false  }">   
                
                <x-nymt.html.subtitle>Section 8: Filming & Photography</x-nymt.html.subtitle>
                <p>NYMT events are photographed and filmed for archival and marketing purposes. Images may appear on film, in print and online in perpetuity. I give permission to be filmed or photographed for these purposes and for these images to be stored and duplicated without further permission being sought.</p>
                <br>
                <x-nymt.input.select class="required" model="form.film_permission" label="Filming & Photography Permission" xmodel="filmpermission">
                <option value="" selected>Choose</option>
                <option value="1">I agree</option>
                <option value="2">Other</option>
                </x-nymt.input.select>
                
                <div x-show="filmpermission == '2'">
                <x-nymt.input.text label="Other" placeholder="Tell us about any exceptions to the permission above." wire:model.blur="form.film_permission_other"></x-nymt.input.text>
                </div>
                <div class="text-center">
                <x-nymt.button @click="select('tab-1-7')" class="text-center">Back</x-nymt.button>
                <x-nymt.button wire:click="validateStep(8)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section>  
            <x-nymt.tabs.section class="p-1">   
                
                <x-nymt.html.subtitle>Section 9: Monitoring</x-nymt.html.subtitle>
                <p>We ask this to help with our internal monitoring. You don't have to answer any of these questions if you don't want to.</p>
                <br>
                <x-nymt.input.select model="form.ethnicity" label="Ethnicity">
                <option value="" selected>Select your ethnicity</option>
                <x-nymt.options.ethnicity></x-nymt.options.ethnicity>
                </x-nymt.input.select>
                
                
                <x-nymt.input.textarea label="Education" placeholder="Your school, college or university" wire:model.blur="form.education" infotext="Please enter the name and address" maxlength="1000"></x-nymt.input.textarea>
                @error('form.education') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                
                
                <x-nymt.input.select model="form.education_type" label="Current education">
                <option value="" selected>Choose your current education</option>
                <x-nymt.options.education_type></x-nymt.options.education_type>
                </x-nymt.input.select>
                
                
                <div class="text-center">
                <x-nymt.button @click="select('tab-1-8')" class="text-center">Back</x-nymt.button>
                <x-nymt.button wire:click="validateStep(9)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section>  
            <x-nymt.tabs.section class="p-1">  
                <x-nymt.html.subtitle>Section 10: Marketing emails from NYMT</x-nymt.html.subtitle>
                <p class="pb-2">Would you like to receive occasional NYMT emails that we think will be of interest to you? Your details will not be passed onto third parties other than those working on behalf of NYMT in the UK for the purposes of sending you these occasional emails. Your details would be held in accordance with our privacy policy and the General Data Protection Regulation.</p>
            
                <x-nymt.input.select class="required" label="Emails from NYMT" model="form.marketing_emails">
                    <option value="" selected>Please select an option</option>
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                <div class="text-center">
                <x-nymt.button @click="select('tab-1-9')" class="text-center">Back</x-nymt.button>
                <x-nymt.button wire:click="validateStep(10)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section>  
            <x-nymt.tabs.section class="p-1">   
            
                
                <x-nymt.html.subtitle>Section 11: Terms and Conditions</x-nymt.html.subtitle>
                
                
                <p class="pb-2">I have read and agree to the <a href='https://nymt.org.uk/terms-and-conditions/' target='_blank' style='font-weight: bold; text-decoration: underline; position: relative;'>terms and conditions</a>.</p>
                <x-nymt.input.select  class="required" label="Terms and Conditions" model="form.marketing_terms">
                    <option value="" selected>Please select an option</option>
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                
                <div class="text-center">
                <x-nymt.button @click="select('tab-1-10')" class="text-center">Back</x-nymt.button>
                @if ($form->marketing_terms == "1")
                <x-nymt.button wire:click="save()" class="text-center">Send</x-nymt.button>
                @endif    
                
                <div wire:loading.delay  wire:target="save" class="inline-flex pl-4 pr-4">
                    <svg class="animate-spin h-5 w-5 text-black" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
                </div>
            </x-nymt.tabs.section>  
        </x-slot>
    </x-nymt.tabs.alt> 
            </div>   
            </div>
    
    
    </x-nymt.body>