  <x-slot name="header">
    <div class="flex">
        <div>
            <x-nymt.html.title>{{ $crud }}</x-nymt.html.title>
        </div>
    </div>

    </x-slot>

    <x-nymt.body>
        <x-nymt.tabs.alt>
            <x-slot name="head">
                <x-nymt.html.subtitle>Message here</x-nymt.html.subtitle>
            </x-slot>
    
            <x-slot name="body"> 
    
                <div class="grid grid-cols-1">
            
                    <x-nymt.input.text class="required" label="Main Contact Email" placeholder="Enter Email" wire:model.blur="form.email" infotext="We'll send our contact emails here. For children under 18, this should be a parent or carer's address."></x-nymt.input.text>
                        @error('form.email')  
                        <x-nymt.input.error>{{ $message }}</x-nymt.input.error> 
                        @enderror
                     
                        @if (!$emailExists)   
                            <div class="text-center">
                                <x-nymt.button class="text-center">Next</x-nymt.button>
                            </div>
                        @endif
                        
                        
                        @if ($emailExists)
                        
                            <div class="mt-4 p-4 bg-yellow-100 border-l-4 border-yellow-500 text-yellow-700 rounded">
                                <p>This email is already associated with an account.</p>
                                <p>
                                    <strong>Want to continue your application?</strong><br />
                                    
                                    <div class="mb-4">
                                        <label>Password</label>
                                        <input type="password" wire:model="password" class="w-full border p-2 rounded" required />
                                    </div>
                            
                                    <a wire:click="login" class="bg-blue-500 text-white px-4 py-2 rounded">Login</a>
                                    <a href="{{ route('ycm.password.request') }}" class="text-blue-600 text-sm ml-4">Click here to create/reset your password</a>
                                </p>
                            </div>
                        @endif
        
                </div>
            </x-slot>
            
        </x-nymt.tabs.alt>
    
    </x-nymt.body>