    <div class="">
        <div class="relative sm:flex sm:justify-center sm:items-center min-h-screen bg-dots-darker bg-center dark:bg-dots-lighter dark:bg-gray-900 selection:bg-red-500 selection:text-white">
            
            <div class="bg-white rounded-xl shadow p-8 flex flex-col gap-6 min-w-[35rem]-m">
                
                    @if ($showCategory)
                    
                    <x-nymt.input.select leadingAddOn="Category" model="applicationType">
                        <option value="" selected>Please choose your category</option>
                        <x-nymt.options.categories cpp="1"></x-nymt.options.categories>
                    </x-nymt.input.select>
                    
                    @endif        
                <div class="max-w-xl w-full mx-auto mt-6 px-6 py-4 text-white bg-black shadow-md overflow-hidden">
                    <div class="rounded-md shadow-sm px-3 py-2">
                    <div class="flex items-center">
                        <div class="px-2"><img src="/media/images/NYMT_Logo_24.png" width="100px"></div>
                        <div class="px-2"><p class="text-xl">{{ $applicationTypeLabel }}</p></div>
                    </div>
                    </div>
                </div>
                <div class="max-w-xl w-full mx-auto pt-6 sm:pt-0 text-black text-sm">
                    @if ($applicationType == 'actor')
                    <div>
                        <p class="pb-2">Thanks for signing up to an NYMT audition workshop day! These days are suitable for ages 10–23 and are an opportunity to develop your skills by taking part in acting, singing and dancing activities while being auditioned for a project with NYMT.</p>
                        <p class="pb-2">This form refers to ‘you’ as the auditionee. However, applications for auditionees under the age of 18 should be supervised by, or made by, a parent or carer.</p>
                        <p class="pb-2">The fee for the audition workshop day is £45. After submitting your application, you will be directed to the secure PayPal payment page. You do not need a PayPal account to complete payment – select ‘Pay by debit or credit card’.</p>
                        <p class="pb-2">Additional information about your audition workshop day will be emailed you when your booking is completed.</p>

                    </div>
                    @endif
                    @if ($applicationType == 'musician')
                    <div>
                        <p class="pb-2">Thanks for signing up to audition to be an NYMT Musician! These auditions are suitable for ages 10–23 and are your first step to becoming a musician with NYMT.</p>
                        <p class="pb-2">This form refers to 'you' as the auditionee. However, applications for auditionees under the age of 18 should be supervised by, or made by, a parent.</p>
                        <p class="pb-2">The fee for the audition is £25. After submitting your application, you will be directed to the secure PayPal payment page. You do not need a PayPal account to complete payment – select ‘Pay by debit or credit card’. </p>
                        <p class="pb-2">Additional information about your audition will be emailed you when your booking is completed.</p>
                    </div>
                    @endif
                    @if ($applicationType == 'cpp')
                    <div>
                        <p class="pb-2">Thanks for applying to the NYMT Creative & Production Pathway!</p> 
                        <p class="pb-2">This form refers to 'you' as the applicant. However, applications for anyone under aged 16 or 17 should be supervised by, or made by, a parent. These opportunities are only available to those currently 16 or older.</p>
                        <p class="pb-2">The registration fee is £25. After submitting your application, you will be directed to the secure PayPal payment page. You do not need a PayPal account to complete payment: select ‘Pay by debit or credit card’.</p>
                        <p class="pb-2">Additional information will be emailed you when your registration is completed.</p>
                        <p class="pb-2"><strong>Please note that we are now only considering applications from young people interested in the following roles: Assistant Choreographer; Assistant Stage Manager; Wardrobe Assistant.</strong></p>                    </div>
                    @endif
                </div>
                <div class="max-w-xl w-full mx-auto pt-2 sm:pt-0 text-black">
                    <div>
                        
                    @if ($applicationType == 'actor' || $applicationType == 'musician')
                    <x-nymt.html.subtitle>Date and Location</x-nymt.html.subtitle>
                    <p class="text-sm pb-2">Please select a date and location. We’ll email you the exact timings, but the days are usually mid-morning to early evening.</p>
                    @if ($applicationType == 'actor')
                    <p class="text-sm pb-2">Any auditions not listed below are now fully booked. Do check back though, as new places are sometimes released.</p>
                    @endif
                    @if ($applicationType == 'musician')
                    <p class="text-sm pb-2">Any auditions not listed below are now fully booked. Do check back though, as new places are sometimes released.</p> 
                    @endif 
                    
                    <x-nymt.input.select  model="venuedate_id" label="Choose a date">
                    
                        <option value="">Select your date</option>
                        @foreach ($venuedates as $venuedate)
                            @if ($venuedate->availability() || $venuedate->musicianavailability())
                                @if ($applicationType == 'musician' && $venuedate->musicianavailability())
                                    <option value= {{ $venuedate->id }}>{{ date('l jS F Y', strtotime($venuedate->start_date)) }} | {{ $venuedate->venue->town }}, {{ $venuedate->venue->name }}</option>
                                @elseif ($applicationType == 'actor' && $venuedate->availability() ) 
                                    <option value= {{ $venuedate->id }}>{{ date('l jS F Y', strtotime($venuedate->start_date)) }} | {{ $venuedate->venue->town }}, {{ $venuedate->venue->name }}</option>
                                @endif
                            @endif
                        @endforeach
                    </x-nymt.input.select>
                    
                    @error('venuedate_id')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                    @endif
                    
                    
                    </div>    
                    <div class="w-full">
                        <div class="mx-auto text-black text-center">
                            <x-nymt.button.primary wire:click="register()">Register</x-nymt.button.primary>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>