<div class="max-w-md mx-auto mt-10 bg-white p-6 rounded shadow">
    <h1 class="text-xl font-bold mb-4">Forgot Your Password?</h1>

    <p class="mb-4 text-gray-600">
        Enter your email address below and we'll send you a password reset link.
    </p>

    @if ($status)
        <div class="mb-4 p-2 text-green-600 bg-green-100 border border-green-300 rounded">
            {{ $status }}
        </div>
    @endif

    <form wire:submit.prevent="sendResetLink">
        <div class="mb-4">
            <label for="email" class="block mb-1 font-medium">Email Address</label>
            <input
                wire:model="email"
                type="email"
                id="email"
                required
                class="w-full border border-gray-300 p-2 rounded focus:outline-none focus:ring-2 focus:ring-blue-500"
            />
            @error('email') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
        </div>

        <button
            type="submit"
            class="w-full bg-blue-600 text-white py-2 rounded hover:bg-blue-700 transition"
        >
            Send Reset Link
        </button>
    </form>

    <div class="mt-4 text-center">
        <a href="{{ route('ycm.login') }}" class="text-blue-600 hover:underline text-sm">
            Back to login
        </a>
    </div>
</div>
