    <x-nymt.dialog wire:model="showAddAudition">
        <x-slot:button>
            <x-nymt.button.primarylink >Create Audition</x-nymt.button.primarylink>
        </x-slot:button>
        <x-slot:panel>
            <form wire:submit="addAudition" class="flex flex-col gap-4">
                <x-nymt.html.subtitle>Create an Audition</x-nymt.html.subtitle>
                            
                <hr class="w-[75%]">
        
                <div class="flex rounded-md shadow-sm px-3 py-2 rounded-lg">
                    <span class="inline-flex min-w-[120px] items-center px-3 rounded-l-md border border-r-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm">Choose Venue</span>
                    <select wire:model.live="chosenvenue"
                                @class([
                                'flex-1 px-3 py-2 rounded-lg form-input border-gray-300 block w-full transition duration-150 ease-in-out sm:text-sm sm:leading-5 rounded-none rounded-r-md'
                                ])
                                >
                                <option value="" selected>Choose Venue</option>

                                @foreach ($venues as $venue)
                                    <option value="{{ $venue->id }}">{{ $venue->name }}</option>
                                @endforeach
                    </select>
                </div>
            
                <div class="flex rounded-md shadow-sm px-3 py-2 rounded-lg">
                    <span class="inline-flex min-w-[120px] items-center px-3 rounded-l-md border border-r-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm">Choose Date</span>
                    <select wire:model.live="auditionform.venue_date_id"
                                @class([
                                 'flex-1 px-3 py-2 rounded-lg form-input border-gray-300 block w-full transition duration-150 ease-in-out sm:text-sm sm:leading-5 rounded-none rounded-r-md'
                                ])
                                >
                        <option value="" selected >Choose Date</option>

                        @foreach ($venuedates as $venuedate)
                            <option value="{{ $venuedate->id }}">{{ $venuedate->name }}- {{ $venuedate->start_date }}</option>
                                @endforeach
                    </select>
                </div>

                <x-nymt.dialog.footer>
                    <x-nymt.dialog.close-button>
                        <button type="button" class="text-center rounded-xl bg-slate-300 text-slate-800 px-6 py-2 font-semibold">Cancel</button>
                    </x-nymt.dialog.close-button>
                    <button type="submit" class="text-center rounded-xl bg-green-700 text-white px-6 py-2 font-semibold disabled:cursor-not-allowed disabled:opacity-50">Save</button>
                </x-nymt.dialog.footer>
            </form>
        </x-slot:panel>
    </x-nymt.dialog>