  <x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
    <div>
        <x-nymt.html.title>
        Manage Actor Auditionees for Audition {{ $venuedate->venue->name }} - {{ date('l j F Y', strtotime($venuedate->start_date)) }}
        </x-nymt.html.title>
    </div>
    <div class="md:text-right">
    
    <a class="group" href="?view=grid" title="View Auditionees Grid" alt="View Auditionees Grid">Grid View</a> | 
    <a class="group" href="/venuedates/" title="View Auditions" alt="View Auditions Grid">Find Another Audition</a>
    </div>
    </div>
    </x-slot>

    <x-nymt.body>
        <div class="flex">
           <div class="flex-0">
          <x-nymt.html.subtitle>Group {{ $myauditionees->currentPage(); }}</x-nymt.html.subtitle>
          </div>
        </div>
        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'pastoralstaffonly'))
        <div class="font-normal text-sm text-gray-800 leading-tight border-l-4 pl-2 border-blue-400 mt-2">
        Help NYMT have a <strong>tell us once</strong> approach to name pronunciation. Add any unclear or unusual pronunciations below (e.g <strong>EE-vah-lin</strong>).
        </div> 
        @endif
          <div class="flex-0">
            <div class="flex-none">
              <div class="m-2 p-2 text-right">
            {{ $myauditionees->onEachSide(0)->links() }}
              </div>
            </div>
          </div>

           
            <x-nymt.table>

                <x-slot name="head">


                        <x-nymt.table.heading>First Name</x-nymt.table.heading>
                        <x-nymt.table.heading>Last Name</x-nymt.table.heading>
                        <x-nymt.table.heading>Age</x-nymt.table.heading>
                        <x-nymt.table.heading class="w-40">Tags</x-nymt.table.heading>
                        {{-- Pastoral & Creative Teams don't see payment information. --}} 
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'payments'))
                        <x-nymt.table.heading>Paid?</x-nymt.table.heading>
                        @endif
                        {{-- Pastoral Team don't see scores on the Audition table. --}} 
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'scores'))
                        <x-nymt.table.heading class="w-20">Acting Score</x-nymt.table.heading>
                        <x-nymt.table.heading>Acting Comment</x-nymt.table.heading>
                        <x-nymt.table.heading class="w-20">Singing Score</x-nymt.table.heading>
                        <x-nymt.table.heading>Singing Comment</x-nymt.table.heading>
                        <x-nymt.table.heading class="w-20">Dancing Score</x-nymt.table.heading>
                        <x-nymt.table.heading>Dancing Comment</x-nymt.table.heading>
                        @endif
                        {{-- Pastoral Team don't see scores on the Audition table. --}} 
                        <x-nymt.table.heading>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'scores'))
                        Registration
                        @else
                        Registration
                        @endif
                        </x-nymt.table.heading>
                        
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'pastoralstaffonly'))
                        <x-nymt.table.heading>Name sounds like</x-nymt.table.heading>
                        @else
                        <x-nymt.table.heading>Potential Project(s)</x-nymt.table.heading>
                        @endif
                        {{-- Other roles don't have space for this heading. --}}  
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'pastoralstaffonly'))
                        <x-nymt.table.heading>
                        Profile Quick View    
                        </x-nymt.table.heading>
                        @endif

                        
                </x-slot>

                <x-slot name="body">

                    @foreach($myauditionees as $auditionee)

                    <x-nymt.table.row class="{{ $loop->index % 2 === 0 ? 'bg-gray-50' : '' }}">

                        {{-- This cell shows the comment field in brackets after the firstname, used for pronunciation of firstname --}}
                        <x-nymt.table.cell>
                        {{ ucwords($auditionee->firstname) }}
                         @if (!empty($auditionee->pastoral->comment))
                         <div class="text-gray-500 mt-1">({{ $auditionee->pastoral->comment }})</span>
                        @endif
                            </x-nymt.table.cell>
                        <x-nymt.table.cell>{{ ucwords($auditionee->lastname) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ $auditionee->age }}</x-nymt.table.cell>
                        <x-nymt.table.cell>
                             @foreach($auditionee->tags() as $key => $tag)
                            <x-nymt.html.tag tagType="{{ $key }}">{{ $tag }}</x-nymt.html.tag>
                            @endforeach
                        </x-nymt.table.cell>
                            @foreach($auditionee->auditions as $audition)
                                @if ($audition->venue_date_id == $venuedate->id)
                                    {{-- Pastoral & Creative Teams don't see payment information. --}} 
                                    @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'payments'))
                                    <x-nymt.table.cell>{{ $audition->paid() }}</x-nymt.table.cell>
                                    @endif
                                    @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'scores'))
                                    <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'acting_score', 'input' => 'score'], key(rand() * $audition->id))</x-nymt.table.cell>
                                    <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'acting_comment', 'input' => 'textarea'], key(rand() * $audition->id))</x-nymt.table.cell>
                                    <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'singing_score', 'input' => 'score'], key(rand() * $audition->id))</x-nymt.table.cell>
                                    <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'singing_comment', 'input' => 'textarea'], key(rand() * $audition->id))</x-nymt.table.cell>
                                    <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'dancing_score', 'input' => 'score'], key(rand() * $audition->id))</x-nymt.table.cell>
                                    <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'dancing_comment', 'input' => 'textarea'], key(rand() * $audition->id))</x-nymt.table.cell>
                                    @endif
                                    <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'outcome', 'input' => 'outcome'], key(rand() * $audition->id))</x-nymt.table.cell>
                                    @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'pastoralstaffonly'))
                                    <x-nymt.table.cell>@if ($auditionee->pastoral)
                                    @livewire('component.edit-field',['id'=>$auditionee->pastoral->id,'object'=>'AuditioneePastoral','field'=>'comment', 'input' => 'textarea'], key(rand() * $auditionee->id))
                                        @endif</x-nymt.table.cell>
                                    @else
                                    <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'role_info', 'input' => 'text'], key(rand() * $audition->id))</x-nymt.table.cell>
                                    @endif
                                @endif
                            @endforeach    
                        
                       
                        <x-nymt.table.cell class="text-center">
                            <!--<button
                            class="group"
                            type="button"
                            wire:click="sendAudition({{ $auditionee->id }})" >
                            <x-nymt.icon.mail />
                            </button>-->
                           <a 
    href="/auditionees/edit/{{ $auditionee->id }}"
    target="_blank"
    rel="noopener noreferrer"
    class="group"
    title="edit"
    alt="edit"
>
    <x-nymt.icon.user-circle />
</a>
                        </x-nymt.table.cell>

                    </x-nymt.table.row>

                    @endforeach

                </x-slot>

            </x-nymt.table>
    </x-nymt.body>