 <x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
    <div>
        <x-nymt.html.title>
        Manage YCMs for {{ $course->name }} – {{ date('l j F Y' , strtotime($course->start_date)) }}
        </x-nymt.html.title>
    </div>
    <div class="md:text-right">
    
        <a class="group" href="?view=grid" title="View Attendees" alt="View Attendee Grid">Grid View</a> | 
        <a class="group" href="/courses/" title="View Courses" alt="View Courses Grid">Back to Courses</a>
    </div>
    </div>
    </x-slot>

    <x-nymt.body>


        <div class="flex">
	                    <div wire:loading.delay>Sending...</div>
          </div>
          <div class="flex-0">
          <div class="flex-none">
              <div class="m-2 p-2 text-right">
            {{ $myattendees->onEachSide(0)->links() }}
              </div>
          </div>
          </div>

            <x-nymt.table>

                <x-slot name="head">

                        <x-nymt.table.heading>Firstname</x-nymt.table.heading>
                        <x-nymt.table.heading>Lastname</x-nymt.table.heading>
                        <x-nymt.table.heading>Age</x-nymt.table.heading>
                        <x-nymt.table.heading>Gender</x-nymt.table.heading>
                        <x-nymt.table.heading>Tags</x-nymt.table.heading>
                        <x-nymt.table.heading>Sign Up Date</x-nymt.table.heading>
                        <x-nymt.table.heading>Paid?</x-nymt.table.heading>
                        <x-nymt.table.heading></x-nymt.table.heading>

                </x-slot>

                <x-slot name="body">

                    @foreach($myattendees as $auditionee)

                    <x-nymt.table.row>
                        <x-nymt.table.cell>{{ ucwords($auditionee->firstname) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ ucwords($auditionee->lastname) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ $auditionee->age() }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ $auditionee->gender }}</x-nymt.table.cell>
                        <x-nymt.table.cell>
                             @foreach($auditionee->tags() as $key => $tag)
                            <x-nymt.html.tag tagType="{{ $key }}">{{ $tag }}</x-nymt.html.tag>
                            @endforeach
                        </x-nymt.table.cell>
                        <x-nymt.table.cell>{{  date('Y-m-d' , strtotime($auditionee->course->created_at)) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{  $auditionee->course->paid() }}</x-nymt.table.cell>
                        
                        <x-nymt.table.cell class="text-center">
                            <!--<button
                            class="group"
                            type="button"
                            wire:click="sendCourse({{ $auditionee->id }},{{ $course->id }})"    
                            wire:loading.attr="disabled"
                             >
                                
                            <x-nymt.icon.mail /></button>-->
                            <button
                            class="group"
                            type="button"
                            wire:click="edit({{ $auditionee->id }})"    
                            wire:loading.attr="disabled"
                             >
                            <x-nymt.icon.user-circle /></button>
                        </x-nymt.table.cell>

                    </x-nymt.table.row>

                    @endforeach

                </x-slot>

            </x-nymt.table>
    </x-nymt.body>