    <x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
    <div>
        <x-nymt.html.title>
        Manage Young Company Members
        </x-nymt.html.title>
    </div>
    <div class="md:text-right">
    
    </div>
    </x-slot>

    <x-nymt.body>
    @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'read'))    

        <div class="flex">
          <div class="flex-none">
            <x-nymt.button.primarylink href="{{ url('/auditionees/create/') }}">New YCM</x-nymt.button.primarylink>
          </div>
          <div class="flex-auto flex">
            <div class="flex-auto">
                <input wire:model.live="inputsearch"  class="shadow appearance-none border rounded w-full py-2 px-3 my-3 ml-2 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" type="text" placeholder="Search by name or email..."/>
            </div>
            <div class="m-1">
                <x-nymt.input.select  model="categoryfilter">
                <option value="" selected>Filter by category</option>
                    <x-nymt.options.categories></x-nymt.options.categories>
                </x-nymt.input.select>
            </div>
            <div class="m-1">
                <x-nymt.input.select  model="venuefilter">
                <option value="" selected>Filter by audition</option>
                    
                @foreach($venues as $venue)
                
                    <option value="{{ $venue->id }}" selected>{{ $venue->name }}</option>
                    
                @endforeach   
                </x-nymt.input.select>
            </div>
            
          </div>
          <div class="flex-auto">
              <div class="m-1 text-right">
                  <x-nymt.input.text leadingAddOn="Rows per page" placeholder="Enter number of rows per page" wire:model.live.debounce.500ms="perPage" />
              </div>
          </div>
            
          </div>
          <div class="flex-auto">
          <div class="flex-none">
              <div class="m-1 text-right">
            {{ $myauditionees->onEachSide(0)->links() }}
              </div>
          </div>
          </div>

            <x-nymt.table>

                <x-slot name="head">

                        <x-nymt.table.heading sortable wire:click="sortBy('firstname')" :direction="$sortField === 'firstname' ? $sortDirection : null">First Name</x-nymt.table.heading>
                        <x-nymt.table.heading sortable wire:click="sortBy('lastname')" :direction="$sortField === 'lastname' ? $sortDirection : null">Last Name</x-nymt.table.heading>
                        <x-nymt.table.heading>Guardian Email</x-nymt.table.heading>
                        <x-nymt.table.heading>Age</x-nymt.table.heading>
                        <x-nymt.table.heading>Tags</x-nymt.table.heading>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'payments'))
                        <x-nymt.table.heading>Paid?</x-nymt.table.heading>
                        @endif
                        <x-nymt.table.heading class="w-48">Musical Instruments</x-nymt.table.heading>
                        {{--<x-nymt.table.heading>Category / Role</x-nymt.table.heading>--}}
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'scores'))
                        <x-nymt.table.heading>Musician/Singing Comments</x-nymt.table.heading>
                        @endif
                        <x-nymt.table.heading>
                            @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'scores'))
                            Outcome
                            @else
                            Registration
                            @endif
                            </x-nymt.table.heading>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'scores'))
                        <x-nymt.table.heading>Potential Role(s)</x-nymt.table.heading>
                        @endif
                        <x-nymt.table.heading class="w-32"></x-nymt.table.heading>
                        
                </x-slot>

                <x-slot name="body">

                    @foreach($myauditionees as $auditionee)

                        <x-nymt.table.row class="{{ $loop->index % 2 === 0 ? 'bg-gray-50' : '' }}">

                        <x-nymt.table.cell>{{ ucwords($auditionee->firstname) }}
                         @if (!empty($auditionee->pastoral->comment))
                         <div class="text-gray-500 mt-1">({{ $auditionee->pastoral->comment }})</span>
                        @endif</x-nymt.table.cell>
                        <x-nymt.table.cell>{{  ucwords($auditionee->lastname) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{  ucwords($auditionee->guardian->email) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ $auditionee->age }}</x-nymt.table.cell>
                        <x-nymt.table.cell>
                             @foreach($auditionee->tags() as $key => $tag)
                            <x-nymt.html.tag tagType="{{ $key }}">{{ $tag }}</x-nymt.html.tag>
                            @endforeach
                        </x-nymt.table.cell>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'payments'))
                        <x-nymt.table.cell>{!! $auditionee->paid() !!}</x-nymt.table.cell>
                        @endif
                        <x-nymt.table.cell>{{ $auditionee->musical_instruments }}</x-nymt.table.cell>
                        {{--<x-nymt.table.cell>{{ $auditionee->ycm_type() }}</x-nymt.table.cell>--}}
                        @if (count($auditionee->auditions) > 0)
                            @foreach($auditionee->auditions as $audition)
                                @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'scores'))
                                    <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'singing_comment','input' => 'textarea'], key(rand() * $audition->id))</x-nymt.table.cell>
                                @endif
                                {{--These cells are headed as 'Registration' for Pastoral Staff, but it's the same field.--}}
                                <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'outcome', 'input' => 'outcome'], key(rand() * $audition->id))</x-nymt.table.cell>
                                @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'scores'))
                                    <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'role_info', 'input' => 'text'], key(rand() * $audition->id))</x-nymt.table.cell>
                                @endif
                            @endforeach    
                        @else
                            @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'scores'))
                             <x-nymt.table.cell colspan="3">
                                    <b>No Audition Yet</b>
                             </x-nymt.table.cell> 
                            @else
                             <x-nymt.table.cell>
                                    <b>No Audition Yet</b>
                             </x-nymt.table.cell>                                 
                            @endif
                        @endif
                        

                        <x-nymt.table.cell>
                        <x-nymt.icon.group>
                        <a 
                        href="/auditionees/edit/{{ $auditionee->id }}"
                        target="_blank"
                        rel="noopener noreferrer"
                        class="group flex"
                        title="edit"
                        alt="edit"
                        >
                        <x-nymt.icon.user-circle />
                        </a>                        
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                        <button type="button" class="group flex" wire:click="delete({{ $auditionee->id }})"  wire:confirm='are you sure you want delete this auditionee? this is not reversable' title="Delete" alt="Delete"><x-nymt.icon.bin /></button>
                        @endif    
                        </x-nymt.icon.group>
                        </x-nymt.table.cell>

                    </x-nymt.table.row>

                    @endforeach

                </x-slot>

            </x-nymt.table>
    @endif        
    </x-nymt.body>