<x-slot name="header">
    <div class="flex">
    <div class="grow">
    <x-nymt.html.title>
        {{ $this->crud }} Course @if ($form->course_id) - {{ $form->course->name }} @endif
    </x-nymt.html.title>
    </div>
    <div class="md:text-right">
    <a class="group" href="/courses/" title="Courses" alt="View Courses">Courses</a>
    </div>
    </x-slot>

    <x-nymt.body>

    <div>
    <form wire:submit="save">

    <x-nymt.tabs>
        <x-slot name="head">
            <x-nymt.tabs.label>Course Details</x-nymt.label>
            @if ($form->course_id) 
            <x-nymt.tabs.label>Courses Attendees ({{ count($form->course->attendees) }}  / {{ $form->course->capacity }})</x-nymt.label>
            @endif
        </x-slot>

        <x-slot name="body">       
    
            <x-nymt.tabs.section>    
        
                <x-nymt.input.text leadingAddOn="Name" placeholder="Enter Name" wire:model.blur="form.name"></x-nymt.input.text>
                    @error('form.name') <span class="error">{{ $message }}</span> @enderror
                
                <x-nymt.input.textarea label="Brief Description" placeholder="Brief Description" wire:model.blur="form.description"></x-nymt.input.textarea>
                
                
                <x-nymt.input.text leadingAddOn="Location" placeholder="Enter Location" wire:model.blur="form.location"></x-nymt.input.text>

                <x-nymt.input.text leadingAddOn="Start Date" wire:model.blur="form.start_date" type="date"></x-nymt.input.text>
                
                <x-nymt.input.text leadingAddOn="End Date" wire:model.blur="form.end_date" type="date"></x-nymt.input.text>
                <x-nymt.input.text leadingAddOn="Price" placeholder="Enter Price " wire:model.blur="form.price"></x-nymt.input.text>
     
                <x-nymt.input.select notlive leadingAddOn="Residential" model="form.residential">
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                <x-nymt.input.text leadingAddOn="Capacity" placeholder="Enter Capacity" wire:model.blur="form.capacity"></x-nymt.input.text>
        
                <x-nymt.input.textarea label="Email Text" placeholder="Email Text" wire:model.blur="form.email_text"></x-nymt.input.textarea>
            <div class="text-center">
            <button type="submit" class="relative max-w-sm w-full bg-blue-500 py-3 px-8 rounded-lg text-white font-medium disabled:cursor-not-allowed disabled:opacity-75">
                Save

                <div wire:loading.flex class="absolute top-0 right-0 bottom-0 items-center pr-4">
                    <svg class="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
            </button>
        </div>
            </x-nymt.tabs.section>  
            
            @if ($form->course_id) 
            
            <x-nymt.tabs.section>    
        
        
            <x-nymt.table>

                <x-slot name="head">
                    
                        <x-nymt.table.heading>Auditionee</x-nymt.table.heading>
                        <x-nymt.table.heading>Sign up Date</x-nymt.table.heading>
                        <x-nymt.table.heading></x-nymt.table.heading>

                </x-slot>

                <x-slot name="body">
                    @if (count($form->course->attendees) >  0)
                    @foreach($form->course->attendees as $attendee)
                    <x-nymt.table.row>
                        <x-nymt.table.cell>{{ $attendee->auditionee->firstname}} {{ $attendee->auditionee->lastname}}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{  date('Y-m-d' , strtotime($attendee->created_at)) }}</x-nymt.table.cell>
                        
                        
                        <x-nymt.table.cell>
                        <x-nymt.icon.group>
                        <button
                            class="group flex"
                            type="button"
                            wire:click="editAttendee({{ $attendee->auditionee->id }})" 
                            wire:confirm="Are you sure you want to go to this Attendee?"
                            title="Go to Attendee" alt="Go to Attendee"
                            ><x-nymt.icon.edit /></button>
                        <button
                            class="group flex"
                            type="button"
                            wire:click="deleteAttendee({{ $attendee->id }})" 
                            wire:confirm="Are you sure you want to delete this Attendee?"
                            title="Delete" alt="Delete"
                            ><x-nymt.icon.bin /></button>
                        </x-nymt.icon.group>
                        </x-nymt.table.cell>
                    
                    </x-nymt.table.row>
                    @endforeach
                    @else
                    No Attendees Yet
                    @endif
                </x-slot>

            </x-nymt.table>
        
        
            </x-nymt.tabs.section>  
        
            @endif
        </x-slot>
    </x-nymt.tabs>
    </form>

    </div>
    </x-nymt.body>