<x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
    <div>
    <x-nymt.html.title>
        Manage Courses
    </x-nymt.html.title>
    </div>
    <div class="md:text-right">
    
    </div>
</div>

</x-slot>

    <x-nymt.body>
        <div class="flex">
        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
          <div class="flex-none">
            <x-nymt.button.primarylink href="{{ url('/courses/create') }}">Create Course</x-nymt.button.primarylink>
        
          </div>
        @endif
	                    
          <div class="grow">
            <input wire:model.live="inputsearch"  class="shadow appearance-none border rounded w-full py-2 px-3 my-3 ml-2 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" type="text" placeholder="Search for course name..."/>
          </div>
          
          <div class="flex-0">
              <div class="m-1 text-right">
                  <x-nymt.input.text leadingAddOn="Rows Per Page" placeholder="Enter Number of rows per page" wire:model.live.debounce.500ms="perPage" />
              </div>
          </div>
            
          </div>
          <div class="flex-1">
          <div class="flex-none">
              <div class="m-1 text-right">
            {{ $mycourses->onEachSide(0)->links() }}
              </div>
          </div>
          </div>
            <x-nymt.table>

                <x-slot name="head">
                    
                        <x-nymt.table.heading sortable wire:click="sortBy('name')" :direction="$sortField === 'name' ? $sortDirection : null">Course Name</x-nymt.table.heading>
                        <x-nymt.table.heading sortable wire:click="sortBy('location')" :direction="$sortField === 'location' ? $sortDirection : null">Location</x-nymt.table.heading>
                        <x-nymt.table.heading sortable wire:click="sortBy('start_date')" :direction="$sortField === 'start_date' ? $sortDirection : null">Start Date</x-nymt.table.heading>
                        <x-nymt.table.heading sortable wire:click="sortBy('end_date')" :direction="$sortField === 'end_date' ? $sortDirection : null">End Date</x-nymt.table.heading>
                        <x-nymt.table.heading class="text-center">Price</x-nymt.table.heading>
                        <x-nymt.table.heading class="text-center">Residential?</x-nymt.table.heading>
                        <x-nymt.table.heading colspan="2" class="text-center">Capacity</x-nymt.table.heading>
                        <x-nymt.table.heading colspan="2" class="text-center">Attendees</x-nymt.table.heading>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                        <x-nymt.table.heading class="text-center">Action</x-nymt.table.heading>
                        @endif

                </x-slot>

                <x-slot name="body">

                    @foreach($mycourses as $course)
                    
                    <x-nymt.table.row class="{{ $loop->index % 2 === 0 ? 'bg-gray-50' : '' }}">

                        <x-nymt.table.cell>@livewire('component.edit-field',['id'=>$course->id,'object'=>'Course','field'=>'name'], key(rand() * $course->id))</x-nymt.table.cell>
                        <x-nymt.table.cell>@livewire('component.edit-field',['id'=>$course->id,'object'=>'Course','field'=>'location'], key(rand() * $course->id))</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ date('j F Y', strtotime($course->start_date)) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ date('j F Y', strtotime($course->end_date)) }}</x-nymt.table.cell>
                        
                        <x-nymt.table.cell class="text-center">@livewire('component.edit-field',['id'=>$course->id,'object'=>'Course','field'=>'price'], key(rand() * $course->id))</x-nymt.table.cell>

                        <x-nymt.table.cell class="text-center">
                        {{ $course->isresidential() }}
                        </x-nymt.table.cell>

                        <x-nymt.table.cell class="text-center">@livewire('component.edit-field',['id'=>$course->id,'object'=>'Course','field'=>'capacity'], key(rand() * $course->id))</x-nymt.table.cell>

                        <x-nymt.table.cell>@if ($course->availability()) Places Available @else Fully Booked @endif</x-nymt.table.cell>
                        <x-nymt.table.cell class="text-center">{{ count($course->attendees) }}</x-nymt.table.cell>
                        <x-nymt.table.cell class="text-center"> 
                            <button
                            type="button"
                            wire:click="course({{ $course->id }})" 
                            ><x-nymt.icon.eye />
                            </button>
                            @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                           <a href="/export-csv/course/{{ $course->id }}" target="_blank" class="text-center"><x-nymt.icon.download /></a>
                           @endif
                        </x-nymt.table.cell>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                        <x-nymt.table.cell class="text-center"> 
                            <button
                            type="button"
                            wire:click="edit({{ $course->id }})" 
                            ><x-nymt.icon.edit /></button>
                            <button
                            type="button"
                            wire:click="delete({{ $course->id }})" 
                            wire:confirm="Are you sure you want to delete this course?"
                            title="Delete" alt="Delete"
                            ><x-nymt.icon.bin />
                            </button>
                        </x-nymt.table.cell>
                        @endif

                    </x-nymt.table.row>

                    @endforeach

                </x-slot>

            </x-nymt.table>
    </x-nymt.body>