<x-app-layout>

    <div class="py-4">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg">
                <div class="p-4 lg:p-6 border-b border-gray-200" style="background-color: #36454F;">

    <h1 class="text-2xl font-medium text-white">
        Welcome to Rolecall!
    </h1>
    @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'creativestaffonly'))
    <p class="mt-4 text-white text-sm leading-relaxed">You're viewing Rolecall as <strong>creative staff</strong>. Find your audition below and select the icon to view actor auditionees and enter your comments and scores. Select the Rolecall logo at the top to return to this page.
    </br>
    </br>
        If you're auditioning musicians, view them in the ‘All YCMs’ window in the top menu and enter your comments there.
    </p>
    @endif
    @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'pastoralstaffonly'))
    <p class="mt-4 text-white text-sm leading-relaxed">You're viewing Rolecall as <strong>pastoral staff</strong>. To register actor YCMs for an audition, select the view icon next to the relevant audition below. 
    </br>
    </br>
    Tip: Because we split actors into age groups, your registration list is ordered by age. When you register someone, ask them their name and how old they are, which will help you find them. Don't forget to tell them their group number!
    </br>
    </br>
    Musicians and CPP don't appear on the auditions lists below. You'll find them in <strong>All YCMs</strong> (above), which you can filter by audition and category.
    </p>
    @endif
</div>

<div class="bg-gray-200 bg-opacity-25 grid grid-cols-1  gap-6 lg:gap-8 p-6 lg:p-8">
    

    <div>
        
        <x-nymt.html.subtitle>Upcoming Auditions</x-nymt.html.subtitle>
        
        <livewire:component.audition-dash />
    </div>
    
    
    <div>
        
        <x-nymt.html.subtitle>Upcoming Courses</x-nymt.html.subtitle>
        
        <livewire:component.course-dash />
    </div>
    
    <div>
        
        <x-nymt.html.subtitle>Current Projects</x-nymt.html.subtitle>
        
        <livewire:component.project-dash />
    </div>

    @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
    <div>
        <div class="flex items-center">
            
            <x-nymt.html.subtitle>Downloads only for Admins & Super Admins</x-nymt.html.subtitle>
        </div>

        <p class="mt-4 text-gray-500 text-sm leading-relaxed">
            Download CPPs <a href="/export-csv/cpp/2024" target="_blank" class="text-center"><x-nymt.icon.download /></a>
            
                @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'csv-all'))
            <br>
            Download all YCMs for all Columns <a href="export-csv-all" target="_blank" class="text-center"><x-nymt.icon.download /></a>
                @endif
        </p>
    </div>

    @endif
</div>
            </div>
        </div>
    </div>
</x-app-layout>
