<div>
            <x-nymt.table>
                <x-slot name="head">
                    
                        <x-nymt.table.heading>Name</x-nymt.table.heading>
                        <x-nymt.table.heading>Details</x-nymt.table.heading>
                        <x-nymt.table.heading>Cast Date</x-nymt.table.heading>
                        <x-nymt.table.heading>Start Date</x-nymt.table.heading>
                        <x-nymt.table.heading>End Date</x-nymt.table.heading>
                        <x-nymt.table.heading class="text-center">View Roles</x-nymt.table.heading>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'pastoral'))
                        <x-nymt.table.heading class="text-center">CSV</x-nymt.table.heading>
                        @endif

                </x-slot>

                <x-slot name="body">

                    @foreach($myprojects as $project)
                    
                    <x-nymt.table.row>

                        <x-nymt.table.cell>{{ $project->name }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ $this->excerpt($project->details, 50) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ date('Y-m-d' , strtotime($project->cast_date)) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ date('Y-m-d' , strtotime($project->start_date)) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{  date('Y-m-d' , strtotime($project->end_date)) }}</x-nymt.table.cell>
                        <x-nymt.table.cell class="text-center"> 
                        <button
                            class="group text-center"
                            type="button"
                            wire:click="project({{ $project->id }})" 
                            ><x-nymt.icon.eye /></button> </x-nymt.table.cell>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'pastoral'))
                        <x-nymt.table.cell class="text-center">
                           <a href="/export-csv/project/{{ $project->id }}" target="_blank" class="text-center"><x-nymt.icon.download /></a>
                        </x-nymt.table.cell>
                        @endif
                    </x-nymt.table.row>

                    @endforeach

                </x-slot>

            </x-nymt.table>
</div>