<x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
    <div>
    <x-nymt.html.title>
        {{ $this->crud }} Role 
        @if ($form->role_id) 
        for {{ $form->role->project->name }}
        @endif
    </x-nymt.html.title>
    </div>
    <div class="md:text-right">
        @if ($form->project_id) 
    <a class="group" href="/projects/edit/{{ $form->project_id }}" title="View Project" alt="View Project">Back to Project</a> | 
        @endif
    <a class="group" href="/roles/" title="View Venue Date Grid" alt="View Roles Grid">Roles</a>
    </div>
    </x-slot>

    <x-nymt.body>

    <div>

    <form wire:submit="save">
        
        

    <x-nymt.tabs>
        <x-slot name="head">
            <x-nymt.tabs.label>Role Details</x-nymt.label>
        </x-slot>

        <x-slot name="body">  
    
            <x-nymt.tabs.section>       
            @if ($form->role_id)
            <div class="grid justify-items-end">
                <div class="">
                    <x-nymt.button.primarylink href="{{ url('/roles/create/'.$form->project_id) }}">Create Another Role</x-nymt.button.primarylink>
                </div>
            </div>  
            @endif
        
                <x-nymt.input.text leadingAddOn="Name" placeholder="Enter Name" wire:model.blur="form.name"></x-nymt.input.text>
                    @error('form.name') <span class="error">{{ $message }}</span> @enderror
                
                <x-nymt.input.text leadingAddOn="Comment" wire:model.blur="form.comment"></x-nymt.input.text>
                
        
            <div class="text-center">
            <button type="submit" class="relative max-w-sm w-full bg-blue-500 py-3 px-8 rounded-lg text-white font-medium disabled:cursor-not-allowed disabled:opacity-75">
                Save

                <div wire:loading.flex class="absolute top-0 right-0 bottom-0 items-center pr-4">
                    <svg class="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
            </button>
        </div>
            </x-nymt.tabs.section>  
            
  
        </x-slot>
    </x-nymt.tabs>
    </form>

</div>
    </x-nymt.body>