<x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
    <div>
    <x-nymt.html.title>
        Manage Projects
    </x-nymt.html.title>
    </div>
    <div class="md:text-right">
    
    </div>
</div>

</x-slot>

    <x-nymt.body>
        <div class="flex">
        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
          <div class="flex-none">
            <x-nymt.button.primarylink href="{{ url('/projects/create') }}">Create Project</x-nymt.button.primarylink>
            
          </div>
        @endif
	                    
          <div class="flex-1">
            <input wire:model.live="inputsearch"  class="shadow appearance-none border rounded w-full py-2 px-3 my-3 ml-2 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" type="text" placeholder="Search for name or town..."/>
          </div>
          <div class="flex-0">
              <div class="m-1 text-right">
                  <x-nymt.input.text leadingAddOn="Rows Per Page" placeholder="Enter Number of rows per page" wire:model.live.debounce.500ms="perPage" />
              </div>
          </div>
            
          </div>
          <div class="flex-1">
          <div class="flex-none">
              <div class="m-1 text-right">
            {{ $myprojects->onEachSide(0)->links() }}
              </div>
          </div>
          </div>
            <x-nymt.table>
                
                <x-slot name="head">
                    
                        <x-nymt.table.heading sortable wire:click="sortBy('name')" :direction="$sortField === 'name' ? $sortDirection : null">Name</x-nymt.table.heading>
                        <x-nymt.table.heading>Details</x-nymt.table.heading>
                        <x-nymt.table.heading>Cast Date</x-nymt.table.heading>
                        <x-nymt.table.heading>Start Date</x-nymt.table.heading>
                        <x-nymt.table.heading>End Date</x-nymt.table.heading>
                        <x-nymt.table.heading class="text-center">Roles Cast</x-nymt.table.heading>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                        <x-nymt.table.heading class="text-center">Action</x-nymt.table.heading>
                        @endif

                </x-slot>

                <x-slot name="body">

                    @foreach($myprojects as $project)
                    
                    <x-nymt.table.row>

                        <x-nymt.table.cell>@livewire('component.edit-field',['id'=>$project->id,'object'=>'Project','field'=>'name'], key(rand() * $project->id))</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ $this->excerpt($project->details, 50) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ date('Y-m-d' , strtotime($project->cast_date)) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ date('Y-m-d' , strtotime($project->start_date)) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{  date('Y-m-d' , strtotime($project->end_date)) }}</x-nymt.table.cell>
                        
                        
                        
                        <x-nymt.table.cell class="text-center">
                            <button
                            class="group text-center"
                            type="button"
                            wire:click="roles({{ $project->id }})" 
                            ><x-nymt.icon.eye /></button> 
                            @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                           <a href="/export-csv/project/{{ $project->id }}" target="_blank" class="text-center"><x-nymt.icon.download /></a>
                           @endif
                        </x-nymt.table.cell>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                        <x-nymt.table.cell class="text-center">
                            <button
                            type="button"
                            wire:click="edit({{ $project->id }})" 
                            ><x-nymt.icon.edit /></button>
                            <button
                            type="button"
                            wire:click="delete({{ $project->id }})" 
                            wire:confirm="Are you sure you want to delete this Project?"
                            title="Delete" alt="Delete"
                            ><x-nymt.icon.bin /></button>
                        </x-nymt.table.cell>
                        @endif
                    </x-nymt.table.row>

                    @endforeach

                </x-slot>

            </x-nymt.table>
    </x-nymt.body>